/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.telemetry;

import com.google.gson.Gson;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.alsp.telemetry.TelemetryEvent;
import org.mule.alsp.telemetry.TelemetryManager;
import org.mule.alsp.telemetry.TelemetryMessageTypes;

@RunWith(value=MockitoJUnitRunner.class)
public class TelemeryManagerTest {
    @Test
    public void testAddRawData() throws InterruptedException {
        TelemetryManager manager1 = new TelemetryManager();
        Assert.assertFalse((boolean)manager1.addRawData(null));
        TelemetryEvent event = new TelemetryEvent();
        Assert.assertFalse((boolean)manager1.addRawData(event));
        event.setMessageType(TelemetryMessageTypes.BEGIN_ALSP_COMPLETION);
        Assert.assertFalse((boolean)manager1.addRawData(event));
        event.setTime(Long.valueOf(1L));
        Assert.assertTrue((boolean)manager1.addRawData(event));
        event.setTime(null);
        event.setMessageType(TelemetryMessageTypes.END_ALSP_COMPLETION);
        Assert.assertFalse((boolean)manager1.addRawData(event));
        event.setTime(Long.valueOf(10L));
        Assert.assertTrue((boolean)manager1.addRawData(event));
        manager1 = new TelemetryManager(null);
        Assert.assertFalse((boolean)manager1.addRawData(event));
    }

    @Test
    public void testHandleTelemetryMessage() {
        TelemetryManager manager1 = (TelemetryManager)Mockito.spy((Object)new TelemetryManager());
        manager1.handleTelemetryMessage(null);
        ((TelemetryManager)Mockito.verify((Object)manager1, (VerificationMode)Mockito.atMost((int)0))).addRawData(null);
        JSONObject jsonObject = new JSONObject();
        manager1.handleTelemetryMessage((Object)jsonObject);
        ((TelemetryManager)Mockito.verify((Object)manager1, (VerificationMode)Mockito.times((int)1))).addRawData((TelemetryEvent)ArgumentMatchers.argThat(t -> t.getMessageType() == TelemetryMessageTypes.UNKNOWN));
        String json1 = "{ \"event\": \"AstManager : amfInit\",\"message\": \"Initialize AMF begin\",\"uri\": \"\",\"time\": 1.571140562948E12,\"uuid\": \"b72d56ea-19e5-4251-9619-9466d4339141\"}";
        manager1.handleTelemetryMessage((Object)new Gson().toJsonTree(new Gson().fromJson(json1, TelemetryEvent.class)));
        ((TelemetryManager)Mockito.verify((Object)manager1, (VerificationMode)Mockito.times((int)1))).addRawData((TelemetryEvent)ArgumentMatchers.argThat(t -> t.getMessageType() == TelemetryMessageTypes.UNKNOWN && t.getTime() != null && StringUtils.isNotEmpty((CharSequence)t.getEvent())));
        String json2 = "{ \"event\": \"AstManager : amfInit\",\"messageType\": \"BEGIN_AMF_INIT\",\"message\": \"Initialize AMF begin\",\"uri\": \"\",\"time\": 1.571140562948E12,\"uuid\": \"b72d56ea-19e5-4251-9619-9466d4339141\"}";
        manager1.handleTelemetryMessage((Object)new Gson().toJsonTree(new Gson().fromJson(json2, TelemetryEvent.class)));
        ((TelemetryManager)Mockito.verify((Object)manager1, (VerificationMode)Mockito.times((int)1))).addRawData((TelemetryEvent)ArgumentMatchers.argThat(t -> t.getMessageType() == TelemetryMessageTypes.BEGIN_AMF_INIT && t.getTime() != null && StringUtils.isNotEmpty((CharSequence)t.getEvent())));
    }
}

