/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.protocol.server;

import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.alsp.protocol.ALSPTextDocumentService;
import org.mule.alsp.protocol.server.ALSPLanguageServerWrapper;
import org.mulesoft.als.server.lsp4j.LanguageServerImpl;
import org.mulesoft.als.server.lsp4j.extension.AlsInitializeParams;

@RunWith(value=MockitoJUnitRunner.class)
public class ALSPLanguageServerWrapperTest {
    @Mock
    LanguageServerImpl server;
    ALSPLanguageServerWrapper wrapper = null;
    private static final String VALID_JAR = "jar:file:/localhost.jar!/a.raml";
    private static final String NON_JAR = "file:/localhost/a.raml";
    private static final String INVALID_JAR = "file:/localhost.jar!/a.raml";
    private static final String PARENT_VALID_JAR = "jar:file:/localhost.jar!/";
    private static final String PARENT_NON_JAR = "file:/localhost/";

    @Before
    public void setUp() throws Exception {
        this.wrapper = new ALSPLanguageServerWrapper(this.server);
    }

    @Test
    public void testInitialize() {
        AlsInitializeParams params = new AlsInitializeParams();
        params.setRootUri(PARENT_NON_JAR);
        this.wrapper.initialize(params);
        ((LanguageServerImpl)Mockito.verify((Object)this.server, (VerificationMode)Mockito.times((int)1))).initialize((AlsInitializeParams)ArgumentMatchers.argThat(m -> m.getRootUri().equals(PARENT_NON_JAR)));
        params.setRootUri(VALID_JAR);
        this.wrapper.initialize(params);
        ((LanguageServerImpl)Mockito.verify((Object)this.server, (VerificationMode)Mockito.times((int)2))).initialize((AlsInitializeParams)ArgumentMatchers.argThat(m -> m.getRootUri().equals(PARENT_VALID_JAR)));
        params.setRootUri(INVALID_JAR);
        this.wrapper.initialize(params);
        ((LanguageServerImpl)Mockito.verify((Object)this.server, (VerificationMode)Mockito.times((int)3))).initialize((AlsInitializeParams)ArgumentMatchers.argThat(m -> m.getRootUri().equals(PARENT_VALID_JAR)));
    }

    @Test
    public void testInitializedInitializedParams() {
        InitializedParams params = new InitializedParams();
        this.wrapper.initialized(params);
        ((LanguageServerImpl)Mockito.verify((Object)this.server, (VerificationMode)Mockito.times((int)1))).initialized(params);
    }

    @Test
    public void testInitialized() {
        this.wrapper.initialized();
        ((LanguageServerImpl)Mockito.verify((Object)this.server, (VerificationMode)Mockito.times((int)1))).initialized(null);
    }

    @Test
    public void testShutdown() {
        this.wrapper.shutdown();
        ((LanguageServerImpl)Mockito.verify((Object)this.server, (VerificationMode)Mockito.times((int)1))).shutdown();
    }

    @Test
    public void testExit() {
        this.wrapper.exit();
        ((LanguageServerImpl)Mockito.verify((Object)this.server, (VerificationMode)Mockito.times((int)1))).exit();
    }

    @Test
    public void testGetTextDocumentService() {
        TextDocumentService docService = this.wrapper.getTextDocumentService();
        ((LanguageServerImpl)Mockito.verify((Object)this.server, (VerificationMode)Mockito.times((int)1))).getTextDocumentService();
        Assert.assertTrue((boolean)(docService instanceof ALSPTextDocumentService));
    }

    @Test
    public void testGetWorkspaceService() {
        this.wrapper.getWorkspaceService();
        ((LanguageServerImpl)Mockito.verify((Object)this.server, (VerificationMode)Mockito.times((int)1))).getWorkspaceService();
    }
}

