/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.protocol.client;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.alsp.protocol.client.ALSPLanguageClientDecorator;
import org.mulesoft.lsp.feature.telemetry.TelemetryMessage;

@RunWith(value=MockitoJUnitRunner.class)
public class ALSPLanguageClientDecoratorTest {
    @Mock
    LanguageClient client;
    ALSPLanguageClientDecorator languageClient;

    @Before
    public void setUp() throws Exception {
        this.languageClient = new ALSPLanguageClientDecorator(this.client);
    }

    @Test
    public void testConfiguration() throws InterruptedException, ExecutionException {
        ConfigurationParams configParams = new ConfigurationParams();
        ArrayList expectedList = new ArrayList();
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> expectedList);
        ((LanguageClient)Mockito.doReturn(future).when((Object)this.client)).configuration(configParams);
        CompletableFuture actual = this.languageClient.configuration(configParams);
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).configuration(configParams);
        List actualList = (List)actual.get();
        Assert.assertEquals((long)actualList.size(), (long)expectedList.size());
    }

    @Test
    public void testRegisterCapability() {
        RegistrationParams params = new RegistrationParams();
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {});
        ((LanguageClient)Mockito.doReturn(future).when((Object)this.client)).registerCapability(params);
        this.languageClient.registerCapability(params);
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).registerCapability(params);
    }

    @Test
    public void testWorkspaceFolders() throws InterruptedException, ExecutionException {
        ArrayList expectedList = new ArrayList();
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> expectedList);
        ((LanguageClient)Mockito.doReturn(future).when((Object)this.client)).workspaceFolders();
        CompletableFuture actual = this.languageClient.workspaceFolders();
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).workspaceFolders();
        List actualList = (List)actual.get();
        Assert.assertEquals((long)actualList.size(), (long)expectedList.size());
    }

    @Test
    public void testUnregisterCapability() {
        UnregistrationParams params = new UnregistrationParams();
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {});
        ((LanguageClient)Mockito.doReturn(future).when((Object)this.client)).unregisterCapability(params);
        this.languageClient.unregisterCapability(params);
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).unregisterCapability(params);
    }

    @Test
    public void testTelemetryEvent() {
        Object obj = new Object();
        this.languageClient.telemetryEvent(obj);
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)0))).telemetryEvent(obj);
        String json1 = "{ \"event\": \"AstManager : amfInit\",\"message\": \"Initialize AMF begin\",\"uri\": \"\",\"time\": 1.571140562948E12,\"uuid\": \"b72d56ea-19e5-4251-9619-9466d4339141\"}";
        obj = new Gson().fromJson(json1, TelemetryMessage.class);
        this.languageClient.telemetryEvent(obj);
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).telemetryEvent(obj);
        json1 = "{ \"event\": \"AstManager : amfInit\",\"message\": \"Initialize AMF begin\",\"uri\": \"file://jar:file:/localhost.jar!/a.raml\",\"time\": 1.571140562948E12,\"uuid\": \"b72d56ea-19e5-4251-9619-9466d4339141\"}";
        obj = new Gson().fromJson(json1, TelemetryMessage.class);
        this.languageClient.telemetryEvent(obj);
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)0))).telemetryEvent(ArgumentMatchers.argThat(m -> ((TelemetryMessage)m).uri().equals("file://jar:file:/localhost.jar!/a.raml")));
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).telemetryEvent(ArgumentMatchers.argThat(m -> ((TelemetryMessage)m).uri().equals("jar:file:/localhost.jar!/a.raml")));
    }

    @Test
    public void testPublishDiagnostics() {
        PublishDiagnosticsParams params = new PublishDiagnosticsParams();
        params.setUri("file:/localhost/a.raml");
        this.languageClient.publishDiagnostics(params);
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).publishDiagnostics((PublishDiagnosticsParams)ArgumentMatchers.argThat(m -> m.getUri().equals("file:/localhost/a.raml")));
        params.setUri("jar:file:/localhost.jar!/a.raml");
        this.languageClient.publishDiagnostics(params);
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)0))).publishDiagnostics((PublishDiagnosticsParams)ArgumentMatchers.argThat(m -> m.getUri().equals("jar:file:/localhost.jar!/a.raml")));
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)2))).publishDiagnostics((PublishDiagnosticsParams)ArgumentMatchers.argThat(m -> m.getUri().equals("")));
    }

    @Test
    public void testShowMessage() {
        this.languageClient.showMessage(null);
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)0))).showMessage(null);
        MessageParams params = new MessageParams();
        this.languageClient.showMessage(params);
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)0))).showMessage(params);
        params.setType(MessageType.Error);
        this.languageClient.showMessage(params);
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).showMessage(params);
    }

    @Test
    public void testShowMessageRequest() throws InterruptedException, ExecutionException {
        ShowMessageRequestParams params = new ShowMessageRequestParams();
        new ArrayList();
        CompletableFuture<MessageActionItem> future = CompletableFuture.supplyAsync(() -> new MessageActionItem("foo"));
        ((LanguageClient)Mockito.doReturn(future).when((Object)this.client)).showMessageRequest(params);
        CompletableFuture actual = this.languageClient.showMessageRequest(params);
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).showMessageRequest(params);
        MessageActionItem actualMsg = (MessageActionItem)actual.get();
        Assert.assertEquals((Object)actualMsg.getTitle(), (Object)"foo");
    }

    @Test
    public void testLogMessage() {
        MessageParams params = new MessageParams();
        params.setMessage("msg");
        this.languageClient.logMessage(params);
        ((LanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)1))).logMessage(params);
    }
}

