/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.protocol.client;

import java.util.UUID;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.alsp.dummies.DummyALSLanguageClient;
import org.mule.alsp.protocol.client.ALSLanguageClient;
import org.mule.alsp.telemetry.TelemetryManager;

public class ALSLanguageClientTest {
    private static final String WORKSPACE_EXECUTE_COMMAND = "workspace/executeCommand";

    @Test
    public void shouldExecute() {
        DummyALSLanguageClient mock = (DummyALSLanguageClient)((Object)Mockito.mock(DummyALSLanguageClient.class));
        ((DummyALSLanguageClient)((Object)Mockito.doReturn((Object)UUID.randomUUID()).when((Object)mock))).getUUID();
        UUID id = mock.getUUID();
        Assert.assertThat((Object)id, (Matcher)CoreMatchers.instanceOf(UUID.class));
    }

    @Test
    public void shouldExecuteGetCommand() {
        UUID id = UUID.randomUUID();
        DummyALSLanguageClient mock = (DummyALSLanguageClient)((Object)Mockito.spy((Object)((Object)new DummyALSLanguageClient())));
        mock.registerCommands(id, new String[]{WORKSPACE_EXECUTE_COMMAND});
        Assert.assertEquals((Object)id.toString(), (Object)mock.getRegistration().getId());
    }

    @Test
    public void shouldReturn_WhenWindowsIsNull() {
        DummyALSLanguageClient dummy = new DummyALSLanguageClient();
        DummyALSLanguageClient spy = (DummyALSLanguageClient)((Object)Mockito.spy((Object)((Object)dummy)));
        IWorkbench workbench = (IWorkbench)Mockito.mock(IWorkbench.class);
        IWorkbenchWindow[] windows = null;
        ((DummyALSLanguageClient)((Object)Mockito.doReturn((Object)workbench).when((Object)spy))).getWorkbench();
        ((DummyALSLanguageClient)((Object)Mockito.doReturn(windows).when((Object)spy))).getWindows();
        spy.startListener();
        ((DummyALSLanguageClient)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)0)))).addListeners(windows);
    }

    @Test
    public void shouldInvokeAddListeners_whenWindowsIsNotNull() {
        DummyALSLanguageClient dummy = new DummyALSLanguageClient();
        DummyALSLanguageClient spy = (DummyALSLanguageClient)((Object)Mockito.spy((Object)((Object)dummy)));
        IWorkbench workbench = (IWorkbench)Mockito.mock(IWorkbench.class);
        IWorkbenchWindow window = (IWorkbenchWindow)Mockito.mock(IWorkbenchWindow.class);
        IWorkbenchWindow[] windows = new IWorkbenchWindow[]{window};
        IEditorPart text = (IEditorPart)Mockito.mock(IEditorPart.class);
        IEditorReference ref = (IEditorReference)Mockito.mock(IEditorReference.class);
        IWorkbenchPage page = (IWorkbenchPage)Mockito.mock(IWorkbenchPage.class);
        IEditorReference[] refs = new IEditorReference[]{ref};
        ((DummyALSLanguageClient)((Object)Mockito.doReturn((Object)workbench).when((Object)spy))).getWorkbench();
        ((DummyALSLanguageClient)((Object)Mockito.doReturn((Object)windows).when((Object)spy))).getWindows();
        ((IWorkbenchWindow)Mockito.doReturn((Object)page).when((Object)window)).getActivePage();
        ((IWorkbenchPage)Mockito.doReturn((Object)text).when((Object)page)).getActiveEditor();
        ((IWorkbenchPage)Mockito.doReturn((Object)refs).when((Object)page)).getEditorReferences();
        spy.startListener();
        ((DummyALSLanguageClient)((Object)Mockito.verify((Object)((Object)spy), (VerificationMode)Mockito.times((int)1)))).addListeners(windows);
    }

    @Test
    public void shouldInitializeClass() {
        ALSLanguageClient dummy = new ALSLanguageClient();
        ALSLanguageClient spy = (ALSLanguageClient)Mockito.spy((Object)dummy);
        IWorkbench workbench = (IWorkbench)Mockito.mock(IWorkbench.class);
        IWorkbenchWindow window = (IWorkbenchWindow)Mockito.mock(IWorkbenchWindow.class);
        IWorkbenchWindow[] windows = new IWorkbenchWindow[]{window};
        IEditorPart text = (IEditorPart)Mockito.mock(IEditorPart.class);
        IEditorReference ref = (IEditorReference)Mockito.mock(IEditorReference.class);
        IWorkbenchPage page = (IWorkbenchPage)Mockito.mock(IWorkbenchPage.class);
        IEditorReference[] refs = new IEditorReference[]{ref};
        ((ALSLanguageClient)Mockito.doReturn((Object)workbench).when((Object)spy)).getWorkbench();
        ((ALSLanguageClient)Mockito.doReturn((Object)windows).when((Object)spy)).getWindows();
        ((IWorkbenchWindow)Mockito.doReturn((Object)page).when((Object)window)).getActivePage();
        ((IWorkbenchPage)Mockito.doReturn((Object)text).when((Object)page)).getActiveEditor();
        ((IWorkbenchPage)Mockito.doReturn((Object)refs).when((Object)page)).getEditorReferences();
        spy.init();
        ((ALSLanguageClient)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).startListener();
    }

    @Test
    public void testHandleTelemetryEvent() {
        TelemetryManager mockedTelemetryManager = (TelemetryManager)Mockito.mock(TelemetryManager.class);
        ALSLanguageClient dummy = new ALSLanguageClient(mockedTelemetryManager);
        ALSLanguageClient spy = (ALSLanguageClient)Mockito.spy((Object)dummy);
        JSONObject jsonObject = new JSONObject();
        spy.telemetryEvent((Object)jsonObject);
        ((TelemetryManager)Mockito.verify((Object)mockedTelemetryManager, (VerificationMode)Mockito.times((int)1))).handleTelemetryMessage((Object)jsonObject);
    }
}

