/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DeclarationParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.ImplementationParams;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TypeDefinitionParams;
import org.eclipse.lsp4j.TypeHierarchyItem;
import org.eclipse.lsp4j.TypeHierarchyPrepareParams;
import org.eclipse.lsp4j.TypeHierarchySubtypesParams;
import org.eclipse.lsp4j.TypeHierarchySupertypesParams;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WillSaveTextDocumentParams;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.alsp.protocol.ALSPTextDocumentService;

@RunWith(value=MockitoJUnitRunner.class)
public class ALSPTextDocumentServiceTest {
    @Mock
    TextDocumentService service;
    TextDocumentIdentifier docIdJar;
    TextDocumentIdentifier docIdInvalidJar;
    TextDocumentIdentifier docId;
    TextDocumentItem docItemIdJar;
    TextDocumentItem docItemIdInvalidJar;
    TextDocumentItem docItemId;
    private static final String VALID_JAR = "jar:file:/localhost.jar!/a.raml";
    private static final String NON_JAR = "file:/localhost/a.raml";
    private static final String INVALID_JAR = "file:/localhost.jar!/a.raml";
    ALSPTextDocumentService alspService;

    @Before
    public void setUp() throws Exception {
        this.alspService = new ALSPTextDocumentService(this.service);
        this.docId = new TextDocumentIdentifier();
        this.docIdJar = new TextDocumentIdentifier();
        this.docIdInvalidJar = new TextDocumentIdentifier();
        this.docId.setUri(NON_JAR);
        this.docIdJar.setUri(VALID_JAR);
        this.docIdInvalidJar.setUri(INVALID_JAR);
        this.docItemId = new TextDocumentItem();
        this.docItemIdJar = new TextDocumentItem();
        this.docItemIdInvalidJar = new TextDocumentItem();
        this.docItemId.setUri(NON_JAR);
        this.docItemIdJar.setUri(VALID_JAR);
        this.docItemIdInvalidJar.setUri(INVALID_JAR);
    }

    @Test
    public void testCompletion() {
        CompletionParams params = new CompletionParams();
        params.setTextDocument(this.docId);
        this.alspService.completion(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).completion((CompletionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.completion(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).completion((CompletionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.completion(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).completion((CompletionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).completion((CompletionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    public void testResolveCompletionItem() {
        CompletionItem params = new CompletionItem("foo");
        this.alspService.resolveCompletionItem(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).resolveCompletionItem(params);
    }

    @Test
    public void testHover() {
        HoverParams params = new HoverParams();
        params.setTextDocument(this.docId);
        this.alspService.hover(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).hover((HoverParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.hover(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).hover((HoverParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.hover(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).hover((HoverParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).hover((HoverParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testDeclaration() {
        DeclarationParams params = new DeclarationParams();
        params.setTextDocument(this.docId);
        this.alspService.declaration(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).declaration((DeclarationParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.declaration(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).declaration((DeclarationParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.declaration(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).declaration((DeclarationParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).declaration((DeclarationParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testDefinition() {
        DefinitionParams params = new DefinitionParams();
        params.setTextDocument(this.docId);
        this.alspService.definition(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).definition((DefinitionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.definition(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).definition((DefinitionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.definition(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).definition((DefinitionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).definition((DefinitionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testTypeDefinition() {
        TypeDefinitionParams params = new TypeDefinitionParams();
        params.setTextDocument(this.docId);
        this.alspService.typeDefinition(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).typeDefinition((TypeDefinitionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.typeDefinition(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).typeDefinition((TypeDefinitionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.typeDefinition(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).typeDefinition((TypeDefinitionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).typeDefinition((TypeDefinitionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testImplementation() {
        ImplementationParams params = new ImplementationParams();
        params.setTextDocument(this.docId);
        this.alspService.implementation(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).implementation((ImplementationParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.implementation(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).implementation((ImplementationParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.implementation(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).implementation((ImplementationParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).implementation((ImplementationParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testReferences() {
        ReferenceParams params = new ReferenceParams();
        params.setTextDocument(this.docId);
        this.alspService.references(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).references((ReferenceParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.references(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).references((ReferenceParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.references(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).references((ReferenceParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).references((ReferenceParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testDocumentHighlight() {
        DocumentHighlightParams params = new DocumentHighlightParams();
        params.setTextDocument(this.docId);
        this.alspService.documentHighlight(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).documentHighlight((DocumentHighlightParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.documentHighlight(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).documentHighlight((DocumentHighlightParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.documentHighlight(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).documentHighlight((DocumentHighlightParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).documentHighlight((DocumentHighlightParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testDocumentSymbol() {
        DocumentSymbolParams params = new DocumentSymbolParams();
        params.setTextDocument(this.docId);
        this.alspService.documentSymbol(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).documentSymbol((DocumentSymbolParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.documentSymbol(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).documentSymbol((DocumentSymbolParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.documentSymbol(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).documentSymbol((DocumentSymbolParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).documentSymbol((DocumentSymbolParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testCodeAction() {
        CodeActionParams params = new CodeActionParams();
        params.setTextDocument(this.docId);
        this.alspService.codeAction(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).codeAction((CodeActionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.codeAction(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).codeAction((CodeActionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.codeAction(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).codeAction((CodeActionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).codeAction((CodeActionParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testCodeLens() {
        CodeLensParams params = new CodeLensParams();
        params.setTextDocument(this.docId);
        this.alspService.codeLens(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).codeLens((CodeLensParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.codeLens(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).codeLens((CodeLensParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.codeLens(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).codeLens((CodeLensParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).codeLens((CodeLensParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testResolveCodeLens() {
        CodeLens params = new CodeLens(new Range());
        this.alspService.resolveCodeLens(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).resolveCodeLens(params);
    }

    @Test
    public void testFormatting() {
        DocumentFormattingParams params = new DocumentFormattingParams();
        params.setTextDocument(this.docId);
        this.alspService.formatting(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).formatting((DocumentFormattingParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.formatting(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).formatting((DocumentFormattingParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.formatting(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).formatting((DocumentFormattingParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).formatting((DocumentFormattingParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testRangeFormatting() {
        DocumentRangeFormattingParams params = new DocumentRangeFormattingParams();
        params.setTextDocument(this.docId);
        this.alspService.rangeFormatting(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).rangeFormatting((DocumentRangeFormattingParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.rangeFormatting(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).rangeFormatting((DocumentRangeFormattingParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.rangeFormatting(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).rangeFormatting((DocumentRangeFormattingParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).rangeFormatting((DocumentRangeFormattingParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testOnTypeFormatting() {
        DocumentOnTypeFormattingParams params = new DocumentOnTypeFormattingParams();
        params.setTextDocument(this.docId);
        this.alspService.onTypeFormatting(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).onTypeFormatting((DocumentOnTypeFormattingParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.onTypeFormatting(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).onTypeFormatting((DocumentOnTypeFormattingParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.onTypeFormatting(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).onTypeFormatting((DocumentOnTypeFormattingParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).onTypeFormatting((DocumentOnTypeFormattingParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testRename() {
        RenameParams params = new RenameParams();
        params.setTextDocument(this.docId);
        this.alspService.rename(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).rename((RenameParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.rename(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).rename((RenameParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.rename(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).rename((RenameParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).rename((RenameParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testDidOpen() {
        DidOpenTextDocumentParams params = new DidOpenTextDocumentParams();
        params.setTextDocument(this.docItemId);
        this.alspService.didOpen(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).didOpen((DidOpenTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docItemIdJar);
        this.alspService.didOpen(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).didOpen((DidOpenTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docItemIdInvalidJar);
        this.alspService.didOpen(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).didOpen((DidOpenTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).didOpen((DidOpenTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testDidClose() {
        DidCloseTextDocumentParams params = new DidCloseTextDocumentParams();
        params.setTextDocument(this.docId);
        this.alspService.didClose(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).didClose((DidCloseTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.didClose(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).didClose((DidCloseTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.didClose(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).didClose((DidCloseTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).didClose((DidCloseTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testDidChange() {
        DidChangeTextDocumentParams params = new DidChangeTextDocumentParams();
        params.setTextDocument(new VersionedTextDocumentIdentifier(this.docId.getUri(), Integer.valueOf(0)));
        this.alspService.didChange(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).didChange((DidChangeTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(new VersionedTextDocumentIdentifier(this.docIdJar.getUri(), Integer.valueOf(0)));
        this.alspService.didChange(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).didChange((DidChangeTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(new VersionedTextDocumentIdentifier(this.docIdInvalidJar.getUri(), Integer.valueOf(0)));
        this.alspService.didChange(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).didChange((DidChangeTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).didChange((DidChangeTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testDidSave() {
        DidSaveTextDocumentParams params = new DidSaveTextDocumentParams();
        params.setTextDocument(this.docId);
        this.alspService.didSave(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).didSave((DidSaveTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.didSave(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).didSave((DidSaveTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.didSave(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).didSave((DidSaveTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).didSave((DidSaveTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testWillSave() {
        WillSaveTextDocumentParams params = new WillSaveTextDocumentParams();
        params.setTextDocument(this.docId);
        this.alspService.willSave(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).willSave((WillSaveTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.willSave(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).willSave((WillSaveTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.willSave(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).willSave((WillSaveTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).willSave((WillSaveTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testWillSaveWaitUntil() {
        WillSaveTextDocumentParams params = new WillSaveTextDocumentParams();
        params.setTextDocument(this.docId);
        this.alspService.willSaveWaitUntil(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).willSaveWaitUntil((WillSaveTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.willSaveWaitUntil(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).willSaveWaitUntil((WillSaveTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.willSaveWaitUntil(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).willSaveWaitUntil((WillSaveTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).willSaveWaitUntil((WillSaveTextDocumentParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    private List<DocumentLink> prepareDocumentLinks() {
        ArrayList<DocumentLink> documentLinks = new ArrayList<DocumentLink>();
        documentLinks.add(new DocumentLink(new Range(), NON_JAR));
        documentLinks.add(new DocumentLink(new Range(), VALID_JAR));
        documentLinks.add(new DocumentLink(new Range(), INVALID_JAR));
        return documentLinks;
    }

    @Test
    public void testDocumentLink() throws InterruptedException, ExecutionException {
        DocumentLinkParams params = new DocumentLinkParams();
        params.setTextDocument(this.docId);
        CompletableFuture<List> future = CompletableFuture.supplyAsync(this::prepareDocumentLinks);
        ((TextDocumentService)Mockito.doReturn(future).when((Object)this.service)).documentLink(params);
        CompletableFuture actual = this.alspService.documentLink(params);
        List actualLinks = (List)actual.get();
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).documentLink((DocumentLinkParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        Assert.assertEquals((long)3L, (long)actualLinks.size());
        Assert.assertEquals((Object)NON_JAR, (Object)((DocumentLink)actualLinks.get(0)).getTarget());
        Assert.assertEquals((Object)VALID_JAR, (Object)((DocumentLink)actualLinks.get(1)).getTarget());
        Assert.assertEquals((String)"Should be fixed URI", (Object)VALID_JAR, (Object)((DocumentLink)actualLinks.get(2)).getTarget());
        params.setTextDocument(this.docIdJar);
        this.alspService.documentLink(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).documentLink((DocumentLinkParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.documentLink(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).documentLink((DocumentLinkParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).documentLink((DocumentLinkParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testDocumentLinkResolve() throws InterruptedException, ExecutionException {
        DocumentLink params = new DocumentLink();
        params.setTarget(NON_JAR);
        CompletableFuture<DocumentLink> future = CompletableFuture.supplyAsync(() -> new DocumentLink(new Range(), NON_JAR));
        ((TextDocumentService)Mockito.doReturn(future).when((Object)this.service)).documentLinkResolve(params);
        CompletableFuture actual = this.alspService.documentLinkResolve(params);
        DocumentLink actualLinks = (DocumentLink)actual.get();
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).documentLinkResolve((DocumentLink)ArgumentMatchers.argThat(m -> m.getTarget().equals(NON_JAR)));
        Assert.assertEquals((Object)NON_JAR, (Object)actualLinks.getTarget());
        params = new DocumentLink();
        future = CompletableFuture.supplyAsync(() -> new DocumentLink(new Range(), VALID_JAR));
        params.setTarget(VALID_JAR);
        ((TextDocumentService)Mockito.doReturn(future).when((Object)this.service)).documentLinkResolve(params);
        actual = this.alspService.documentLinkResolve(params);
        actualLinks = (DocumentLink)actual.get();
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).documentLinkResolve((DocumentLink)ArgumentMatchers.argThat(m -> m.getTarget().equals(VALID_JAR)));
        Assert.assertEquals((Object)VALID_JAR, (Object)actualLinks.getTarget());
        params = new DocumentLink();
        future = CompletableFuture.supplyAsync(() -> new DocumentLink(new Range(), INVALID_JAR));
        params.setTarget(INVALID_JAR);
        ((TextDocumentService)Mockito.doReturn(future).when((Object)this.service)).documentLinkResolve(params);
        actual = this.alspService.documentLinkResolve(params);
        actualLinks = (DocumentLink)actual.get();
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).documentLinkResolve((DocumentLink)ArgumentMatchers.argThat(m -> m.getTarget().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).documentLinkResolve((DocumentLink)ArgumentMatchers.argThat(m -> m.getTarget().equals(VALID_JAR)));
        Assert.assertEquals((String)"Should be fixed URI", (Object)VALID_JAR, (Object)actualLinks.getTarget());
    }

    @Test
    public void testDocumentColor() {
        DocumentColorParams params = new DocumentColorParams();
        params.setTextDocument(this.docId);
        this.alspService.documentColor(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).documentColor((DocumentColorParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.documentColor(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).documentColor((DocumentColorParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.documentColor(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).documentColor((DocumentColorParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).documentColor((DocumentColorParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testColorPresentation() {
        ColorPresentationParams params = new ColorPresentationParams();
        params.setTextDocument(this.docId);
        this.alspService.colorPresentation(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).colorPresentation((ColorPresentationParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.colorPresentation(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).colorPresentation((ColorPresentationParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.colorPresentation(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).colorPresentation((ColorPresentationParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).colorPresentation((ColorPresentationParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testFoldingRange() {
        FoldingRangeRequestParams params = new FoldingRangeRequestParams();
        params.setTextDocument(this.docId);
        this.alspService.foldingRange(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).foldingRange((FoldingRangeRequestParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.foldingRange(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).foldingRange((FoldingRangeRequestParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.foldingRange(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).foldingRange((FoldingRangeRequestParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).foldingRange((FoldingRangeRequestParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testPrepareRename() {
        PrepareRenameParams params = new PrepareRenameParams();
        params.setTextDocument(this.docId);
        this.alspService.prepareRename(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).prepareRename((PrepareRenameParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.prepareRename(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).prepareRename((PrepareRenameParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.prepareRename(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).prepareRename((PrepareRenameParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).prepareRename((PrepareRenameParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testPrepareTypeHierarchy() {
        TypeHierarchyPrepareParams params = new TypeHierarchyPrepareParams();
        params.setTextDocument(this.docId);
        this.alspService.prepareTypeHierarchy(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).prepareTypeHierarchy((TypeHierarchyPrepareParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(NON_JAR)));
        params.setTextDocument(this.docIdJar);
        this.alspService.prepareTypeHierarchy(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).prepareTypeHierarchy((TypeHierarchyPrepareParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
        params.setTextDocument(this.docIdInvalidJar);
        this.alspService.prepareTypeHierarchy(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).prepareTypeHierarchy((TypeHierarchyPrepareParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).prepareTypeHierarchy((TypeHierarchyPrepareParams)ArgumentMatchers.argThat(m -> m.getTextDocument().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testTypeHierarchySupertypes() {
        TypeHierarchyItem item = new TypeHierarchyItem("test", SymbolKind.String, "uri", new Range(), new Range());
        TypeHierarchySupertypesParams params = new TypeHierarchySupertypesParams();
        params.setItem(item);
        item.setUri(NON_JAR);
        this.alspService.typeHierarchySupertypes(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).typeHierarchySupertypes((TypeHierarchySupertypesParams)ArgumentMatchers.argThat(m -> m.getItem().getUri().equals(NON_JAR)));
        item.setUri(VALID_JAR);
        this.alspService.typeHierarchySupertypes(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).typeHierarchySupertypes((TypeHierarchySupertypesParams)ArgumentMatchers.argThat(m -> m.getItem().getUri().equals(VALID_JAR)));
        item.setUri(INVALID_JAR);
        this.alspService.typeHierarchySupertypes(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).typeHierarchySupertypes((TypeHierarchySupertypesParams)ArgumentMatchers.argThat(m -> m.getItem().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).typeHierarchySupertypes((TypeHierarchySupertypesParams)ArgumentMatchers.argThat(m -> m.getItem().getUri().equals(VALID_JAR)));
    }

    @Test
    public void testTypeHierarchySubtypes() {
        TypeHierarchyItem item = new TypeHierarchyItem("test", SymbolKind.String, "uri", new Range(), new Range());
        TypeHierarchySubtypesParams params = new TypeHierarchySubtypesParams();
        params.setItem(item);
        item.setUri(NON_JAR);
        this.alspService.typeHierarchySubtypes(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)1))).typeHierarchySubtypes((TypeHierarchySubtypesParams)ArgumentMatchers.argThat(m -> m.getItem().getUri().equals(NON_JAR)));
        item.setUri(VALID_JAR);
        this.alspService.typeHierarchySubtypes(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)2))).typeHierarchySubtypes((TypeHierarchySubtypesParams)ArgumentMatchers.argThat(m -> m.getItem().getUri().equals(VALID_JAR)));
        item.setUri(INVALID_JAR);
        this.alspService.typeHierarchySubtypes(params);
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)0))).typeHierarchySubtypes((TypeHierarchySubtypesParams)ArgumentMatchers.argThat(m -> m.getItem().getUri().equals(INVALID_JAR)));
        ((TextDocumentService)Mockito.verify((Object)this.service, (VerificationMode)Mockito.times((int)3))).typeHierarchySubtypes((TypeHierarchySubtypesParams)ArgumentMatchers.argThat(m -> m.getItem().getUri().equals(VALID_JAR)));
    }
}

