/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.helpers;

import java.net.URI;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.junit.Assert;
import org.junit.Test;
import org.mule.alsp.helpers.LSUtils;

public class LSUtilsTest {
    static final String VALID_JAR_RAML = "jar:file:/a/b.jar!/c.raml";
    static final String VALID_JAR_RAML_SLASH = "jar:file:///a/b.jar!/c.raml";

    @Test
    public void testIsJarURIURI() {
        Assert.assertFalse((boolean)LSUtils.isJarURI((URI)URI.create("file:/a/b.raml")));
        Assert.assertFalse((boolean)LSUtils.isJarURI((URI)URI.create("jar:file:/a/b.raml")));
        Assert.assertTrue((boolean)LSUtils.isJarURI((URI)URI.create(VALID_JAR_RAML)));
        Assert.assertTrue((boolean)LSUtils.isJarURI((URI)URI.create("file:/a/b.jar!/c.raml")));
        Assert.assertTrue((boolean)LSUtils.isJarURI((URI)URI.create("jar:/a/b.jar!/c.raml")));
        Assert.assertTrue((boolean)LSUtils.isJarURI((URI)URI.create("jar:/a/b.zip!/c.raml")));
        Assert.assertFalse((boolean)LSUtils.isJarURI((URI)URI.create("file:///a/b.raml")));
        Assert.assertFalse((boolean)LSUtils.isJarURI((URI)URI.create("jar:file:///a/b.raml")));
        Assert.assertTrue((boolean)LSUtils.isJarURI((URI)URI.create(VALID_JAR_RAML_SLASH)));
        Assert.assertTrue((boolean)LSUtils.isJarURI((URI)URI.create("file:///a/b.jar!/c.raml")));
        Assert.assertTrue((boolean)LSUtils.isJarURI((URI)URI.create("jar:///a/b.jar!/c.raml")));
    }

    @Test
    public void testIsJarURIString() {
        Assert.assertFalse((boolean)LSUtils.isJarURI((String)"file:/a/b.raml"));
        Assert.assertFalse((boolean)LSUtils.isJarURI((String)"jar:file:/a/b.raml"));
        Assert.assertTrue((boolean)LSUtils.isJarURI((String)VALID_JAR_RAML));
        Assert.assertTrue((boolean)LSUtils.isJarURI((String)"file:/a/b.jar!/c.raml"));
        Assert.assertTrue((boolean)LSUtils.isJarURI((String)"jar:/a/b.jar!/c.raml"));
        Assert.assertFalse((boolean)LSUtils.isJarURI((String)"file:///a/b.raml"));
        Assert.assertFalse((boolean)LSUtils.isJarURI((String)"jar:file:///a/b.raml"));
        Assert.assertTrue((boolean)LSUtils.isJarURI((String)VALID_JAR_RAML_SLASH));
        Assert.assertTrue((boolean)LSUtils.isJarURI((String)"file:///a/b.jar!/c.raml"));
        Assert.assertTrue((boolean)LSUtils.isJarURI((String)"jar:///a/b.jar!/c.raml"));
    }

    @Test
    public void testFixURIString() {
        Assert.assertEquals((Object)"file:/a/b.raml", (Object)LSUtils.fixURI((String)"file:/a/b.raml"));
        Assert.assertEquals((Object)"jar:file:/a/b.raml", (Object)LSUtils.fixURI((String)"jar:file:/a/b.raml"));
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)LSUtils.fixURI((String)VALID_JAR_RAML));
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)LSUtils.fixURI((String)"file:/a/b.jar!/c.raml"));
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)LSUtils.fixURI((String)"jar:/a/b.jar!/c.raml"));
        Assert.assertEquals((Object)"file:///a/b.raml", (Object)LSUtils.fixURI((String)"file:///a/b.raml"));
        Assert.assertEquals((Object)"jar:file:///a/b.raml", (Object)LSUtils.fixURI((String)"jar:file:///a/b.raml"));
        Assert.assertEquals((Object)VALID_JAR_RAML_SLASH, (Object)LSUtils.fixURI((String)VALID_JAR_RAML_SLASH));
        Assert.assertEquals((Object)VALID_JAR_RAML_SLASH, (Object)LSUtils.fixURI((String)"file:///a/b.jar!/c.raml"));
        Assert.assertEquals((Object)VALID_JAR_RAML_SLASH, (Object)LSUtils.fixURI((String)"jar:///a/b.jar!/c.raml"));
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)LSUtils.fixURI((String)"file:/a/jar:file:/a/b.jar!/c.raml"));
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)LSUtils.fixURI((String)"jar:file:/a/jar:file:/a/b.jar!/c.raml"));
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)LSUtils.fixURI((String)"file:/jar:file:/a/b.jar!/c.raml"));
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)LSUtils.fixURI((String)"file:///a/jar:file:/a/b.jar!/c.raml"));
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)LSUtils.fixURI((String)"jar:file:///a/jar:file:/a/b.jar!/c.raml"));
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)LSUtils.fixURI((String)"file:///jar:file:/a/b.jar!/c.raml"));
        Assert.assertEquals((Object)VALID_JAR_RAML_SLASH, (Object)LSUtils.fixURI((String)"file:///a/jar:file:///a/b.jar!/c.raml"));
        Assert.assertEquals((Object)VALID_JAR_RAML_SLASH, (Object)LSUtils.fixURI((String)"jar:file:///a/jar:file:///a/b.jar!/c.raml"));
        Assert.assertEquals((Object)VALID_JAR_RAML_SLASH, (Object)LSUtils.fixURI((String)"file:///jar:file:///a/b.jar!/c.raml"));
    }

    @Test
    public void testGetNameInArchive() {
        Assert.assertEquals((Object)"c.raml", (Object)LSUtils.getNameInArchive((String)VALID_JAR_RAML));
        Assert.assertNull((Object)LSUtils.getNameInArchive((String)"file:/c.raml"));
        Assert.assertNull((Object)LSUtils.getNameInArchive(null));
        Assert.assertEquals((Object)"c.raml", (Object)LSUtils.getNameInArchive((URI)URI.create(VALID_JAR_RAML)));
        Assert.assertNull((Object)LSUtils.getNameInArchive((URI)URI.create("file:/c.raml")));
        Assert.assertNull((Object)LSUtils.getNameInArchive(null));
    }

    @Test
    public void testFixParamsObject() {
        DidOpenTextDocumentParams didOpenParams = new DidOpenTextDocumentParams(new TextDocumentItem(VALID_JAR_RAML, "", 0, ""));
        DocumentSymbolParams symbolParams = new DocumentSymbolParams(new TextDocumentIdentifier(VALID_JAR_RAML));
        LSUtils.fixParams((Object)didOpenParams);
        LSUtils.fixParams((Object)symbolParams);
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)didOpenParams.getTextDocument().getUri());
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)symbolParams.getTextDocument().getUri());
        didOpenParams.getTextDocument().setUri("file:/a/b.jar!/c.raml");
        symbolParams.getTextDocument().setUri("file:/a/b.jar!/c.raml");
        LSUtils.fixParams((Object)didOpenParams);
        LSUtils.fixParams((Object)symbolParams);
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)didOpenParams.getTextDocument().getUri());
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)symbolParams.getTextDocument().getUri());
    }

    @Test
    public void testFixParamsPublishDiagnosticsParams() {
        PublishDiagnosticsParams params = new PublishDiagnosticsParams();
        params.setUri(VALID_JAR_RAML);
        LSUtils.fixParams((PublishDiagnosticsParams)params);
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)params.getUri());
        params.setUri("file:/a/b.jar!/c.raml");
        LSUtils.fixParams((PublishDiagnosticsParams)params);
        Assert.assertEquals((Object)VALID_JAR_RAML, (Object)params.getUri());
    }
}

