/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.runtime.CoreException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.alsp.filesystem.JarFileStore;
import org.mule.alsp.testapi.JarUtils;

public class JarFileStoreTest {
    JarFileStore store;
    static final String EXPECTED_BODY = "#%RAML 1.0\r\n\r\ntitle: test API\r\n\r\n/uri:\r\n  get:\r\n    responses:\r\n      200:\r\n        body:\r\n          application/json:\r\n            type: object";
    static final String FILE_IN_JAR = "b.raml";
    static final String JAR_FILE = "target/output.jar";

    @Before
    public void setUp() throws Exception {
        this.store = new JarFileStore(URI.create("jar:file:/localhost/a.jar!/b.raml"));
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)FILE_IN_JAR, (Object)this.store.getName());
        this.store = new JarFileStore(null);
        Assert.assertNull((Object)this.store.getName());
    }

    @Test
    public void testOpenInputStream() throws IOException {
        InputStream is = this.store.openInputStream(0, null);
        Assert.assertNull((Object)is);
        URI uri = JarUtils.create(JAR_FILE, FILE_IN_JAR, EXPECTED_BODY);
        this.store = new JarFileStore(uri);
        is = this.store.openInputStream(0, null);
        Assert.assertNotNull((Object)is);
        String resultBody = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
        Assert.assertEquals((Object)EXPECTED_BODY, (Object)resultBody);
        this.store = new JarFileStore(null);
        is = this.store.openInputStream(0, null);
        Assert.assertNull((Object)is);
    }

    @Test
    public void testToLocalFile() throws CoreException {
        Assert.assertNull((Object)this.store.toLocalFile(0, null));
    }

    @Test
    public void testFetchInfo() {
        IFileInfo info = this.store.fetchInfo();
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)FILE_IN_JAR, (Object)info.getName());
        Assert.assertEquals((Object)true, (Object)info.exists());
        Assert.assertEquals((Object)false, (Object)info.isDirectory());
        Assert.assertEquals((Object)true, (Object)info.getAttribute(2));
    }
}

