/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.filesystem;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.alsp.filesystem.FileJarEntryEditorInput;
import org.mule.alsp.helpers.LSUtils;
import org.mule.alsp.testapi.JarUtils;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.TestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class FileJarEntryEditorInputTest {
    FileJarEntryEditorInput editorInput = null;
    JarEntryEditorInput input = null;
    @Mock
    IFile file;
    @Mock
    JarEntryFile storage;
    URI uri;
    static final String EXPECTED_BODY = "#%RAML 1.0\r\n\r\ntitle: test API\r\n\r\n/uri:\r\n  get:\r\n    responses:\r\n      200:\r\n        body:\r\n          application/json:\r\n            type: object";
    static final String FILE_IN_JAR = "b.raml";
    static final String JAR_FILE = "target/output.jar";

    @Before
    public void setUp() throws Exception {
        this.uri = JarUtils.create(JAR_FILE, FILE_IN_JAR, EXPECTED_BODY);
        this.input = (JarEntryEditorInput)Mockito.spy((Object)new JarEntryEditorInput((IStorage)JarUtils.createJarEntry(JAR_FILE, FILE_IN_JAR)));
        this.editorInput = new FileJarEntryEditorInput((IStorageEditorInput)this.input);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetAdapter() throws IOException {
        Object result = this.editorInput.getAdapter(null);
        Assert.assertNull((Object)result);
        result = this.editorInput.getAdapter(this.file.getClass());
        Assert.assertNull((Object)result);
        result = this.editorInput.getAdapter(FileJarEntryEditorInput.JarLocationProvider.class);
        Assert.assertNotNull((Object)result);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(FileJarEntryEditorInput.JarLocationProvider.class));
        Assert.assertEquals((Object)URI.create("jar:" + new File("").toURI().toString().replaceAll("file:", "") + "target/output.jar!/b.raml"), (Object)((FileJarEntryEditorInput.JarLocationProvider)result).getURI(null));
        URI expectedURI = LSUtils.fixURI((URI)((FileJarEntryEditorInput.JarLocationProvider)result).getURI(null));
        String body = IOUtils.toString((URI)expectedURI, (String)Charset.defaultCharset().displayName());
        Assert.assertEquals((Object)EXPECTED_BODY, (Object)body);
        String base = "jar/";
        TestApi api = new TestApi();
        api.structureTest(this.uri, TestUtils.resolvedURI(base + "outline.json"), "", false);
    }

    @Test
    public void testGetToolTipText() {
        Object result = this.editorInput.getAdapter(FileJarEntryEditorInput.JarLocationProvider.class);
        Assert.assertNotNull((Object)result);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.instanceOf(FileJarEntryEditorInput.JarLocationProvider.class));
        Assert.assertEquals((Object)Paths.get(new File(JAR_FILE).getAbsolutePath(), FILE_IN_JAR).toString(), (Object)this.editorInput.getToolTipText());
    }

    @Test
    public void testGetStorage() throws CoreException {
        IStorage stg = this.editorInput.getStorage();
        Assert.assertNotNull((Object)stg);
        Assert.assertThat((Object)stg, (Matcher)CoreMatchers.instanceOf(JarEntryFile.class));
        ((JarEntryEditorInput)Mockito.verify((Object)this.input, (VerificationMode)Mockito.times((int)1))).getStorage();
    }

    @Test
    public void testGetName() throws CoreException {
        String actual = this.editorInput.getName();
        Assert.assertEquals((Object)FILE_IN_JAR, (Object)actual);
        ((JarEntryEditorInput)Mockito.verify((Object)this.input, (VerificationMode)Mockito.times((int)1))).getName();
    }

    @Test
    public void testEquals() {
        this.editorInput.equals(null);
    }

    @Test
    public void testHashCode() {
        int hash = this.editorInput.hashCode();
        Assert.assertEquals((long)this.input.hashCode(), (long)hash);
    }

    @Test
    public void testGetPersistable() {
        this.editorInput.getPersistable();
        ((JarEntryEditorInput)Mockito.verify((Object)this.input, (VerificationMode)Mockito.times((int)1))).getPersistable();
    }

    @Test
    public void testExists() {
        boolean result = this.editorInput.exists();
        ((JarEntryEditorInput)Mockito.verify((Object)this.input, (VerificationMode)Mockito.times((int)1))).exists();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void testToString() {
        String result = this.editorInput.toString();
        Assert.assertNotNull((Object)result);
    }
}

