/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IWorkbenchPartReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.alsp.ALSPlugin;
import org.mule.alsp.dummies.DummyEditor;
import org.mule.alsp.dummies.DummyEditorInput;
import org.mule.alsp.dummies.DummyFile;
import org.mule.alsp.dummies.DummyIEditiorPartReference;
import org.mule.alsp.dummies.DummyWorkbenchPartReference;
import org.mule.alsp.editor.ActiveEditorListener;

@RunWith(value=MockitoJUnitRunner.class)
public class ActiveEditorListenerTest {
    @Mock
    DummyEditor textEditor;
    @Mock
    DummyEditorInput editorInput;
    @Mock
    DummyFile file;
    @Mock
    LanguageServer ls;
    @Mock
    Command command;
    CompletableFuture<LanguageServer> future = new CompletableFuture();
    List<CompletableFuture<LanguageServer>> list = new ArrayList<CompletableFuture<LanguageServer>>();

    @Before
    public void before() {
        ALSPlugin.getDefault().setAlsInitialized(true);
    }

    @Test
    public void shouldInitializeDidFocusParam() {
        ActiveEditorListener.DidFocusParams dfp = new ActiveEditorListener.DidFocusParams();
        dfp.setUri("www.onet.pl");
        dfp.setVersion(Integer.valueOf(1));
        Assert.assertEquals((Object)"www.onet.pl", (Object)dfp.getUri());
        Assert.assertTrue((1 == dfp.getVersion() ? 1 : 0) != 0);
    }

    @Test
    public void shouldIgnoreElementsOfNotGenericEditor() {
        DummyWorkbenchPartReference mock = new DummyWorkbenchPartReference();
        ActiveEditorListener ael = new ActiveEditorListener();
        ActiveEditorListener spy = (ActiveEditorListener)Mockito.spy((Object)ael);
        ael.partActivated((IWorkbenchPartReference)mock);
        ((ActiveEditorListener)Mockito.verify((Object)spy, (VerificationMode)Mockito.never())).getTextEditor();
    }

    @Test
    public void shouldIgnoreElementsOfNotGenericEditor_withNullEditor() {
        DummyIEditiorPartReference mock = new DummyIEditiorPartReference();
        ActiveEditorListener ael = new ActiveEditorListener();
        ActiveEditorListener spy = (ActiveEditorListener)Mockito.spy((Object)ael);
        ((ActiveEditorListener)Mockito.doReturn(null).when((Object)spy)).getTextEditor();
        spy.partActivated((IWorkbenchPartReference)mock);
        ((ActiveEditorListener)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).getTextEditor();
        ((DummyEditor)Mockito.verify((Object)this.textEditor, (VerificationMode)Mockito.times((int)0))).getEditorInput();
    }

    @Test
    public void shouldIgnoreElementsOfNotGenericEditor_withNullEditorAndNullEditorInput() {
        DummyIEditiorPartReference mock = new DummyIEditiorPartReference();
        ActiveEditorListener ael = new ActiveEditorListener();
        ActiveEditorListener spy = (ActiveEditorListener)Mockito.spy((Object)ael);
        ((ActiveEditorListener)Mockito.doReturn((Object)this.textEditor).when((Object)spy)).getTextEditor();
        ((DummyEditor)Mockito.doReturn(null).when((Object)this.textEditor)).getEditorInput();
        spy.partActivated((IWorkbenchPartReference)mock);
        ((ActiveEditorListener)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).getTextEditor();
        ((DummyEditor)Mockito.verify((Object)this.textEditor, (VerificationMode)Mockito.times((int)1))).getEditorInput();
    }

    @Test
    public void shouldExecuteCommand() {
        DummyIEditiorPartReference mock = new DummyIEditiorPartReference();
        ActiveEditorListener spy = (ActiveEditorListener)Mockito.mock(ActiveEditorListener.class);
        ((ActiveEditorListener)Mockito.doReturn((Object)this.textEditor).when((Object)spy)).getTextEditor();
        ((DummyEditor)Mockito.doReturn((Object)this.editorInput).when((Object)this.textEditor)).getEditorInput();
        ((DummyEditorInput)Mockito.doReturn((Object)new Path("test")).when((Object)this.editorInput)).getPath();
        ((DummyEditorInput)Mockito.doReturn((Object)this.file).when((Object)this.editorInput)).getAdapter(IFile.class);
        this.list.add(this.future);
        ((ActiveEditorListener)Mockito.doCallRealMethod().when((Object)spy)).partActivated((IWorkbenchPartReference)mock);
        spy.partActivated((IWorkbenchPartReference)mock);
        ((ActiveEditorListener)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).getTextEditor();
        ((DummyEditor)Mockito.verify((Object)this.textEditor, (VerificationMode)Mockito.times((int)2))).getEditorInput();
    }

    @Test
    public void partActivatedShouldInvokeEmptyMethods() {
        DummyIEditiorPartReference mock = new DummyIEditiorPartReference();
        ActiveEditorListener spy = (ActiveEditorListener)Mockito.mock(ActiveEditorListener.class);
        IWorkbenchPartReference partRef = (IWorkbenchPartReference)Mockito.mock(IWorkbenchPartReference.class);
        ((ActiveEditorListener)Mockito.doReturn((Object)this.textEditor).when((Object)spy)).getTextEditor();
        ((DummyEditor)Mockito.doReturn((Object)this.editorInput).when((Object)this.textEditor)).getEditorInput();
        ((DummyEditorInput)Mockito.doReturn((Object)new Path("test")).when((Object)this.editorInput)).getPath();
        ((DummyEditorInput)Mockito.doReturn((Object)this.file).when((Object)this.editorInput)).getAdapter(IFile.class);
        this.list.add(this.future);
        ((ActiveEditorListener)Mockito.doCallRealMethod().when((Object)spy)).partActivated((IWorkbenchPartReference)mock);
        spy.partActivated((IWorkbenchPartReference)mock);
        spy.partBroughtToTop(partRef);
        spy.partClosed(partRef);
        spy.partDeactivated(partRef);
        spy.partOpened(partRef);
        spy.partHidden(partRef);
        spy.partVisible(partRef);
        spy.partInputChanged(partRef);
        ((ActiveEditorListener)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).getTextEditor();
        ((DummyEditor)Mockito.verify((Object)this.textEditor, (VerificationMode)Mockito.times((int)2))).getEditorInput();
    }

    @Test(expected=InterruptedException.class)
    public void partActivatedShouldThrowInterruptedException() {
        DummyIEditiorPartReference mock = new DummyIEditiorPartReference();
        ActiveEditorListener spy = (ActiveEditorListener)Mockito.mock(ActiveEditorListener.class);
        ((ActiveEditorListener)Mockito.doAnswer(invocation -> {
            throw new InterruptedException();
        }).when((Object)spy)).partActivated((IWorkbenchPartReference)mock);
        spy.partActivated((IWorkbenchPartReference)mock);
        ((ActiveEditorListener)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).getTextEditor();
        ((DummyEditor)Mockito.verify((Object)this.textEditor, (VerificationMode)Mockito.times((int)2))).getEditorInput();
    }

    @Test(expected=ExecutionException.class)
    public void partActivatedShouldExecutionException() {
        DummyIEditiorPartReference mock = new DummyIEditiorPartReference();
        ActiveEditorListener spy = (ActiveEditorListener)Mockito.mock(ActiveEditorListener.class);
        ((ActiveEditorListener)Mockito.doAnswer(invocation -> {
            throw new ExecutionException("test", null);
        }).when((Object)spy)).partActivated((IWorkbenchPartReference)mock);
        spy.partActivated((IWorkbenchPartReference)mock);
        ((ActiveEditorListener)Mockito.verify((Object)spy, (VerificationMode)Mockito.times((int)1))).getTextEditor();
        ((DummyEditor)Mockito.verify((Object)this.textEditor, (VerificationMode)Mockito.times((int)2))).getEditorInput();
    }
}

