/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.connection;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.alsp.connection.SocketServerLauncher;

public class SocketServerLauncherTest {
    SocketServerLauncher launcher;

    @Before
    public void setUp() throws Exception {
        this.launcher = new SocketServerLauncher();
    }

    @After
    public void tearDown() throws Exception {
        this.launcher = null;
    }

    @Test
    public void testConnection() throws InterruptedException, ExecutionException, UnknownHostException, IOException {
        this.launcher.start();
        CompletableFuture socket = this.launcher.connect();
        Assert.assertNotNull((Object)socket);
        Socket socketClient = new Socket("localhost", this.launcher.getServerPort());
        Assert.assertEquals((long)socketClient.getPort(), (long)this.launcher.getServerPort());
        socketClient.close();
        socket = null;
    }

    @Test
    public void testClose() throws InterruptedException, ExecutionException {
        this.launcher.close();
        this.launcher.start();
        this.launcher.close();
        CompletableFuture future = this.launcher.connect();
        Assert.assertNotNull((Object)future);
        try {
            Assert.assertNull(future.get(5L, TimeUnit.SECONDS));
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
    }
}

