/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp.bugs;

import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.alsp.connection.ALSPSocketConnectionProvider;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.TestUtils;
import org.mule.alsp.testapi.lsp.LanguageServerProxy;
import org.mule.alsp.testapi.params.SuggestionTestParams;
import org.mule.alsp.testapi.params.TestParams;

public class Bug415Test {
    private static TestApi api = null;
    private static LanguageServerProxy proxy = null;

    @BeforeClass
    public static void startup() {
        api = new TestApi(new ALSPSocketConnectionProvider());
        proxy = api.getLanguageServerProxy();
    }

    private TestParams openDocument(String path) {
        SuggestionTestParams testParams = new SuggestionTestParams();
        System.out.println(new File("").getAbsolutePath());
        File jsonApi = new File(path);
        testParams.setUri(jsonApi.toURI());
        String content = TestUtils.readFile(testParams.getUri());
        api.openDocument(testParams.getUri(), content);
        return testParams;
    }

    @Test
    public void testJSONIdentation() throws InterruptedException, ExecutionException {
        TestParams testParams = this.openDocument("src/test/resources/bugs/415/rootCRLF.json");
        CompletionParams params = new CompletionParams(new TextDocumentIdentifier(TestUtils.patchUri(testParams.getUri())), new Position(5, 2));
        List items = (List)proxy.getTextDocumentService().completion(params).get().getLeft();
        CompletionItem item = items.stream().filter(i -> "contact".equals(i.getLabel())).findFirst().orElse(null);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)"\"contact\": {\r\n\t\t\t\"$1\"\r\n\t\t}\r\n", (Object)item.getFilterText());
        testParams = this.openDocument("src/test/resources/bugs/415/root.json");
        params = new CompletionParams(new TextDocumentIdentifier(TestUtils.patchUri(testParams.getUri())), new Position(5, 2));
        items = (List)proxy.getTextDocumentService().completion(params).get().getLeft();
        item = items.stream().filter(i -> "contact".equals(i.getLabel())).findFirst().orElse(null);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)"\"contact\": {\n\t\t\t\"$1\"\n\t\t}\n", (Object)item.getFilterText());
    }

    @Test
    public void testJSONIdentationLevels() throws InterruptedException, ExecutionException {
        TestParams testParams = this.openDocument("src/test/resources/bugs/415/root-4tab-parent.json");
        CompletionParams params = new CompletionParams(new TextDocumentIdentifier(TestUtils.patchUri(testParams.getUri())), new Position(5, 4));
        List items = (List)proxy.getTextDocumentService().completion(params).get().getLeft();
        CompletionItem item = items.stream().filter(i -> "contact".equals(i.getLabel())).findFirst().orElse(null);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)"\"contact\": {\n\t\t\t\t\t\"$1\"\n\t\t\t\t}\n", (Object)item.getFilterText());
        testParams = this.openDocument("src/test/resources/bugs/415/root-4tab-parent.json");
        params = new CompletionParams(new TextDocumentIdentifier(TestUtils.patchUri(testParams.getUri())), new Position(5, 2));
        items = (List)proxy.getTextDocumentService().completion(params).get().getLeft();
        item = items.stream().filter(i -> "contact".equals(i.getLabel())).findFirst().orElse(null);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)"\"contact\": {\n\t\t\t\"$1\"\n\t\t}\n", (Object)item.getFilterText());
    }
}

