/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp;

import java.io.PrintWriter;
import java.net.URI;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageServer;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.alsp.connection.ALSPSocketConnectionProvider;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.TestTelemetryManager;
import org.mule.alsp.testapi.TestUtils;
import org.mule.alsp.testapi.lsp.ClientTextDocumentService;
import org.mule.alsp.testapi.lsp.LanguageServerProxy;
import org.mule.alsp.testapi.params.StructureTestPrams;
import org.mule.alsp.testapi.params.TestParams;
import org.mule.alsp.testapi.strategies.ManageDocumentStrategy;
import org.mule.alsp.testapi.strategies.StructureTestStrategy;

public class StructureRequestTest {
    private static TestApi api = null;

    @BeforeClass
    public static void startup() {
        api = new TestApi();
    }

    @Test
    public void cantFindEditorForUri() {
        String root = "structure/OAS20/structure/";
        PrintWriter logWriter = new PrintWriter(System.out);
        boolean verbose = true;
        URI uri = TestUtils.resolvedURI(root + "test001/api.yml");
        URI json = TestUtils.resolvedURI(root + "test001/api-yaml-outline.json");
        StructureTestPrams params = TestParams.createStructureTestParams(uri, json, "", false);
        ALSPSocketConnectionProvider streamProvider = new ALSPSocketConnectionProvider();
        Launcher<LanguageServer> launcher = api.getServerProxy(streamProvider, logWriter, verbose);
        TestTelemetryManager telemetryManager = new TestTelemetryManager();
        LanguageServerProxy serverProxy = new LanguageServerProxy((LanguageServer)launcher.getRemoteProxy(), telemetryManager);
        ManageDocumentStrategy docStrategy = new ManageDocumentStrategy(serverProxy);
        StructureTestStrategy structureStrategy = new StructureTestStrategy(serverProxy);
        Runnable task1 = () -> {
            structureStrategy.test(params);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            structureStrategy.test(params);
        };
        Runnable task2 = () -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            docStrategy.closeDocument(uri);
        };
        Thread thread1 = new Thread(task1);
        Thread thread2 = new Thread(task2);
        thread1.start();
        thread2.start();
    }

    @Test
    public void badRequestTest() {
        String root = "structure/OAS20/structure/";
        PrintWriter logWriter = new PrintWriter(System.out);
        boolean verbose = true;
        URI uri = TestUtils.resolvedURI(root + "test001/api.yml");
        URI json = TestUtils.resolvedURI(root + "test001/api-yaml-outline.json");
        StructureTestPrams params = TestParams.createStructureTestParams(uri, json, "", false);
        ALSPSocketConnectionProvider streamProvider = new ALSPSocketConnectionProvider();
        Launcher<LanguageServer> launcher = api.getServerProxy(streamProvider, logWriter, verbose);
        TestTelemetryManager telemetryManager = new TestTelemetryManager();
        LanguageServerProxy serverProxy = new LanguageServerProxy((LanguageServer)launcher.getRemoteProxy(), telemetryManager);
        DocumentSymbolParams symbolParams = new DocumentSymbolParams(new TextDocumentIdentifier(TestUtils.patchUri(params.getUri())));
        ClientTextDocumentService decorated = serverProxy.getTextDocumentService();
        Callable<Future> task1 = () -> {
            CompletableFuture fut1 = decorated.documentSymbol(symbolParams);
            CompletableFuture fut2 = decorated.documentSymbol(symbolParams);
            try {
                fut1.get(5L, TimeUnit.SECONDS);
                fut2.get(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
            return fut2;
        };
        try {
            List list = (List)task1.call().get(5L, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)list);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }
}

