/*
 * Decompiled with CFR 0.152.
 */
package org.mule.alsp;

import java.io.PrintWriter;
import java.net.URI;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageServer;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.alsp.connection.ALSPSocketConnectionProvider;
import org.mule.alsp.testapi.TestApi;
import org.mule.alsp.testapi.TestTelemetryManager;
import org.mule.alsp.testapi.TestUtils;
import org.mule.alsp.testapi.lsp.LanguageServerProxy;
import org.mule.alsp.testapi.params.StructureTestPrams;
import org.mule.alsp.testapi.params.TestParams;
import org.mule.alsp.testapi.strategies.ManageDocumentStrategy;
import org.mule.alsp.testapi.strategies.StructureTestStrategy;

public class EditorUriTest {
    private static TestApi api = null;

    @BeforeClass
    public static void startup() {
        api = new TestApi();
    }

    @AfterClass
    public static void cleanup() {
        if (api != null) {
            api.close();
        }
    }

    @Test
    public void cantFindEditorForUri() {
        String root = "structure/OAS20/structure/";
        PrintWriter logWriter = new PrintWriter(System.out);
        boolean verbose = true;
        URI uri = TestUtils.resolvedURI(root + "test001/api.yml");
        URI json = TestUtils.resolvedURI(root + "test001/api-yaml-outline.json");
        StructureTestPrams params = TestParams.createStructureTestParams(uri, json, "", false);
        ALSPSocketConnectionProvider streamProvider = new ALSPSocketConnectionProvider();
        Launcher<LanguageServer> launcher = api.getServerProxy(streamProvider, logWriter, verbose);
        TestTelemetryManager telemetryManager = new TestTelemetryManager();
        LanguageServerProxy serverProxy = new LanguageServerProxy((LanguageServer)launcher.getRemoteProxy(), telemetryManager);
        ManageDocumentStrategy docStrategy = new ManageDocumentStrategy(serverProxy);
        StructureTestStrategy structureStrategy = new StructureTestStrategy(serverProxy);
        Runnable task1 = () -> {
            structureStrategy.test(params);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            structureStrategy.test(params);
        };
        Runnable task2 = () -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            docStrategy.closeDocument(uri);
        };
        Thread thread1 = new Thread(task1);
        Thread thread2 = new Thread(task2);
        thread1.start();
        thread2.start();
        try {
            thread1.join();
            thread2.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

