/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class FileUtils {
    private static final long MAX_ENTRY_SIZE = 0x40000000L;
    private static final long MAX_TOTAL_SIZE = 0x140000000L;
    private static final int MAX_ENTRIES = 10000;
    private static final int COMPRESSION_RATIO_THRESHOLD = 100;

    private FileUtils() {
    }

    public static void unzip(File zipFile, File destinationDir) throws IOException {
        if (!zipFile.exists()) {
            throw new IOException("ZIP file does not exist: " + zipFile.getAbsolutePath());
        }
        if (!zipFile.isFile()) {
            throw new IOException("Not a file: " + zipFile.getAbsolutePath());
        }
        if (!destinationDir.exists()) {
            Files.createDirectories(destinationDir.toPath(), new FileAttribute[0]);
        }
        Path destinationPath = destinationDir.toPath().toRealPath(new LinkOption[0]);
        long totalExtractedSize = 0L;
        int entryCount = 0;
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                long compressionRatio;
                if (++entryCount > 10000) {
                    throw new IOException("ZIP file contains too many entries (max: 10000)");
                }
                String entryName = entry.getName();
                FileUtils.validateEntryName(entryName);
                Path entryPath = destinationPath.resolve(entryName).normalize();
                if (!entryPath.startsWith(destinationPath)) {
                    throw new IOException("Entry is outside of the target directory: " + entryName);
                }
                long entrySize = entry.getSize();
                if (entrySize > 0x40000000L) {
                    throw new IOException("Entry size exceeds maximum allowed size: " + entryName);
                }
                long compressedSize = entry.getCompressedSize();
                if (compressedSize > 0L && entrySize > 0L && (compressionRatio = entrySize / compressedSize) > 100L) {
                    throw new IOException("Entry has suspicious compression ratio: " + entryName);
                }
                if (!entry.isDirectory()) {
                    long extractedSize;
                    File parentDir = entryPath.toFile().getParentFile();
                    if (parentDir != null && !parentDir.exists()) {
                        Files.createDirectories(parentDir.toPath(), new FileAttribute[0]);
                    }
                    if ((totalExtractedSize += (extractedSize = FileUtils.extractFile(zipIn, entryPath.toString(), entrySize))) > 0x140000000L) {
                        throw new IOException("Total extracted size exceeds maximum allowed size");
                    }
                } else {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }

    private static void validateEntryName(String entryName) throws IOException {
        if (entryName == null || entryName.isEmpty()) {
            throw new IOException("Invalid entry name: empty or null");
        }
        if (entryName.startsWith("/") || entryName.startsWith("\\")) {
            throw new IOException("Invalid entry name: absolute path not allowed: " + entryName);
        }
        if (entryName.contains("..")) {
            throw new IOException("Invalid entry name: parent directory reference not allowed: " + entryName);
        }
        for (char c : entryName.toCharArray()) {
            if (!Character.isISOControl(c)) continue;
            throw new IOException("Invalid entry name: contains control characters: " + entryName);
        }
    }

    private static long extractFile(ZipInputStream zipIn, String filePath, long declaredSize) throws IOException {
        long totalBytesRead = 0L;
        byte[] buffer = new byte[4096];
        try (FileOutputStream fos = new FileOutputStream(filePath);){
            int bytesRead;
            while ((bytesRead = zipIn.read(buffer)) != -1) {
                if (declaredSize >= 0L && (totalBytesRead += (long)bytesRead) > declaredSize + (long)buffer.length) {
                    throw new IOException("Extracted size exceeds declared size for: " + filePath);
                }
                if (totalBytesRead > 0x40000000L) {
                    throw new IOException("Entry size exceeds maximum allowed size: " + filePath);
                }
                fos.write(buffer, 0, bytesRead);
            }
        }
        return totalBytesRead;
    }
}

