/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.util;

import com.mulesoft.mule.runtime.gw.util.ClassLoaderContextException;
import java.util.concurrent.Callable;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static void withContextClassLoader(ClassLoader classLoader, Runnable runnable) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public static <T> T withContextClassLoader(ClassLoader classLoader, Callable<T> callable) {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = callable.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassLoaderContextException("Exception during ClassLoader context execution", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

