/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.queue;

import com.mulesoft.mule.runtime.gw.queue.QueueLimitReachedStrategy;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueue;
import java.util.Optional;
import java.util.Queue;

public class DefaultSizeLimitedQueue<T>
implements SizeLimitedQueue<T> {
    protected Queue<T> queue;
    protected QueueLimitReachedStrategy<T> limitReachedStrategy;
    private long limit;
    private long size = 0L;

    public DefaultSizeLimitedQueue(Queue<T> queue, QueueLimitReachedStrategy<T> limitReachedStrategy, long limit) {
        this.queue = queue;
        this.limitReachedStrategy = limitReachedStrategy;
        this.limit = limit;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean add(T element) {
        if (!this.hasCapacity()) {
            return this.limitReachedStrategy.onLimitReached(this, element);
        }
        this.queue.add(element);
        ++this.size;
        return true;
    }

    @Override
    public Optional<T> retrieve() {
        Optional<Object> element = Optional.ofNullable(this.queue.poll());
        element.ifPresent(e -> --this.size);
        return element;
    }

    @Override
    public Optional<T> peek() {
        return Optional.ofNullable(this.queue.peek());
    }

    @Override
    public void clear() {
        this.queue.clear();
        this.size = 0L;
    }

    @Override
    public int size() {
        return new Long(this.size).intValue();
    }

    @Override
    public boolean hasCapacity() {
        return (long)this.size() < this.limit;
    }
}

