/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model.gatekeeper.status;

import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatus;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatusTracker;

public class DefaultGatekeeperStatusTracker
implements GatekeeperStatusTracker {
    private boolean blocked;
    private boolean tracked;
    private boolean untracked;
    private boolean policiesApplied;
    private boolean policiesFailed;
    private boolean contractsAvailable;
    private boolean requiresContracts;
    private boolean silent;

    @Override
    public boolean isBlocked() {
        return this.blocked;
    }

    @Override
    public boolean shouldUnblock() {
        return this.blocked && this.policiesApplied && (!this.requiresContracts || this.contractsAvailable);
    }

    @Override
    public void blocked(boolean silent) {
        this.blocked = true;
        this.silent = silent;
    }

    @Override
    public void unblocked() {
        this.blocked = false;
        this.silent = false;
    }

    @Override
    public void policiesApplied() {
        this.policiesApplied = true;
        this.policiesFailed = false;
    }

    @Override
    public void policyFailure() {
        this.policiesApplied = false;
        this.policiesFailed = true;
    }

    @Override
    public void contractsAvailable() {
        this.contractsAvailable = true;
    }

    @Override
    public void contractsRequired() {
        this.requiresContracts = true;
    }

    @Override
    public void noContractsRequired() {
        this.requiresContracts = false;
    }

    @Override
    public void tracked() {
        this.tracked = true;
    }

    @Override
    public void untracked() {
        this.untracked = true;
    }

    @Override
    public GatekeeperStatus status() {
        if (!this.blocked) {
            return GatekeeperStatus.READY;
        }
        if (this.untracked) {
            return GatekeeperStatus.UNTRACKED;
        }
        if (!(this.tracked || this.policiesFailed || this.policiesApplied)) {
            return GatekeeperStatus.AWAITING_TRACKING;
        }
        if (this.tracked && !this.policiesFailed && !this.policiesApplied) {
            return GatekeeperStatus.AWAITING_POLICIES;
        }
        if (this.policiesFailed) {
            return GatekeeperStatus.POLICIES_FAILED;
        }
        if (this.requiresContracts && !this.contractsAvailable) {
            return GatekeeperStatus.AWAITING_CONTRACTS;
        }
        return GatekeeperStatus.AWAITING_UNBLOCK;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }
}

