/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.healthcheck;

import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.ApiHealthCheckNotReadyException;
import com.mulesoft.agent.exception.ApplicationNotStartedException;
import com.mulesoft.agent.exception.NoSuchApplicationException;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.HealthCheckService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.healthcheck.HealthCheckValidator;
import org.mule.runtime.api.healthcheck.ReadyStatus;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationStatus;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;

@Named(value="mule.agent.healthcheck.service")
@Singleton
public class AgentHealthCheckService
extends ConfigurableAgentService
implements HealthCheckService,
DeploymentServiceAware {
    private static final Logger LOGGER = LogManager.getLogger(AgentHealthCheckService.class);
    public static final String APIS_HEALTHCHECK_NAME = "hdp-apis-healthcheck";
    public static final String HEALTHCHECK_KEY_MASK = "hdp-hc-%s-%s";
    private DeploymentService deploymentService;

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void enable(boolean enabled) throws AgentEnableOperationException {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return Collections.emptyList();
    }

    public void doStart() {
        LOGGER.info("Initializing HealthCheck service");
    }

    public void doStop() {
        LOGGER.info("Stopping HealthCheck service");
    }

    public Optional<String> isReady(String applicationName) throws NoSuchApplicationException, ApplicationNotStartedException, ApiHealthCheckNotReadyException {
        return this.isReady(applicationName, null);
    }

    public Optional<String> isReady(String applicationName, Long apiId) throws NoSuchApplicationException, ApplicationNotStartedException, ApiHealthCheckNotReadyException {
        LOGGER.debug("Checking HealthCheck.isReady({}, {})", (Object)applicationName, (Object)apiId);
        Application application = this.findApplication(applicationName);
        this.validateApplicationMustBeStarted(application);
        if (apiId == null) {
            return this.checkDefaultApplicationHealthCheck(application);
        }
        return this.checkApiGatewayApplicationHealthCheck(application, applicationName, apiId);
    }

    private Application findApplication(String applicationName) throws NoSuchApplicationException {
        Application application = this.deploymentService.findApplication(applicationName);
        if (application == null) {
            LOGGER.debug("Application not found: {}", (Object)applicationName);
            throw new NoSuchApplicationException();
        }
        return application;
    }

    private void validateApplicationMustBeStarted(Application application) throws ApplicationNotStartedException {
        if (!ApplicationStatus.STARTED.equals((Object)application.getStatus())) {
            LOGGER.debug(String.format("Application not started, current status: %s", application.getStatus().name()));
            String message = String.format("Not ready. Status: %s", application.getStatus().name());
            throw new ApplicationNotStartedException(message);
        }
    }

    private Optional<String> checkDefaultApplicationHealthCheck(Application application) throws ApiHealthCheckNotReadyException {
        Collection healthCheckValidators = application.getRegistry().lookupAllByType(HealthCheckValidator.class);
        LOGGER.debug("HealthCheck validators found: {}", (Object)healthCheckValidators.size());
        ArrayList readyStatusList = healthCheckValidators.stream().filter(Objects::nonNull).map(HealthCheckValidator::ready).collect(Collectors.toCollection(ArrayList::new));
        return this.checkStatus(readyStatusList, application.getStatus().name());
    }

    private Optional<String> checkApiGatewayApplicationHealthCheck(Application application, String applicationName, Long apiId) throws ApiHealthCheckNotReadyException {
        Optional hc = application.getRegistry().lookupByName(APIS_HEALTHCHECK_NAME);
        LOGGER.debug("HealthCheck validators found: {}", (Object)hc.isPresent());
        Optional<ReadyStatus> ready = hc.map(hcElement -> (HealthCheckValidator)hcElement.get(String.format(HEALTHCHECK_KEY_MASK, applicationName, apiId))).filter(Objects::nonNull).map(HealthCheckValidator::ready);
        if (!ready.isPresent()) {
            throw new ApiHealthCheckNotReadyException(String.format("ReadyStatus not found. Status: %s", application.getStatus().name()));
        }
        ArrayList<ReadyStatus> readyStatusList = new ArrayList<ReadyStatus>();
        readyStatusList.add(ready.get());
        return this.checkStatus(readyStatusList, application.getStatus().name());
    }

    private Optional<String> checkStatus(ArrayList<ReadyStatus> readyStatusList, String appName) {
        if (readyStatusList.size() == 0) {
            String message = String.format("Not ready. Status: %s", appName);
            throw new ApiHealthCheckNotReadyException(message);
        }
        if (readyStatusList.stream().allMatch(rs -> rs.isReady())) {
            return Optional.empty();
        }
        Optional<ReadyStatus> readyStatus = readyStatusList.stream().filter(Objects::nonNull).filter(rs -> !rs.isReady() && this.statusDescriptionFromReady((ReadyStatus)rs).isPresent()).findFirst();
        if (readyStatus.isPresent()) {
            throw new ApiHealthCheckNotReadyException((String)readyStatus.get().statusDescription().get());
        }
        String message = String.format("Not ready. Status: %s", appName);
        throw new ApiHealthCheckNotReadyException(message);
    }

    private Optional<String> statusDescriptionFromReady(ReadyStatus ready) {
        try {
            return ready.statusDescription() != null ? ready.statusDescription() : Optional.empty();
        }
        catch (NoSuchMethodError e) {
            return Optional.empty();
        }
    }
}

