/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.jdk.touchpoints.setJvm;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.frameworkadmin.LauncherData;
import org.eclipse.equinox.internal.provisional.frameworkadmin.Manipulator;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.util.NLS;
import org.mule.tooling.jdk.touchpoints.TouchpointsActivator;

public class SetJvmAction
extends ProvisioningAction {
    private static final String JDK_BUNDLE_NAME = "org.mule.tooling.jdk";
    public static final String ID = "setJvm";

    public IStatus execute(Map<String, Object> parameters) {
        String jvmArg = (String)parameters.get("jvm");
        if (jvmArg == null) {
            return Util.createError((String)NLS.bind((String)Messages.parameter_not_set, (Object)"jvm", (Object)ID));
        }
        LauncherData launcherData = ((Manipulator)parameters.get("manipulator")).getLauncherData();
        File previous = launcherData.getJvm();
        if (this.shouldUpdateJvm(parameters)) {
            this.doSetJvm(parameters, jvmArg, launcherData, previous);
        }
        return Status.OK_STATUS;
    }

    public IStatus undo(Map<String, Object> parameters) {
        return this.doUndo(parameters);
    }

    private boolean isUpgrade(Map<String, Object> parameters) {
        boolean isUpgrade = false;
        Object operand = parameters.get("operand");
        if (operand instanceof InstallableUnitOperand) {
            isUpgrade = ((InstallableUnitOperand)operand).first() != null;
        }
        return isUpgrade;
    }

    private boolean shouldUpdateJvm(Map<String, Object> parameters) {
        return !this.isUpgrade(parameters) || this.isOldVersion(this.getRunningJvmParam());
    }

    private String getRunningJvmParam() {
        EclipseCommandsVM vm;
        String eclipseCommands = System.getProperty("eclipse.commands");
        if (eclipseCommands != null && (vm = new EclipseCommandsVM(eclipseCommands)).hasVM()) {
            return vm.getVM();
        }
        return null;
    }

    private boolean isOldVersion(String previous) {
        TouchpointsActivator.debug(() -> "Old JDK: " + previous);
        return previous != null && previous.contains(JDK_BUNDLE_NAME);
    }

    private void doSetJvm(Map<String, Object> parameters, String jvmArg, LauncherData launcherData, File previous) {
        File jvm = "null".equals(jvmArg) ? null : new File(jvmArg);
        this.getMemento().put("previousValue", (Object)(previous == null ? null : previous.getPath()));
        launcherData.setJvm(jvm);
        if (jvm != null) {
            SetJvmAction.adjustWorkbenchSystemProperties(jvm);
        }
    }

    private IStatus doUndo(Map<String, Object> parameters) {
        IStatus undoStatus = Status.OK_STATUS;
        TouchpointsActivator.debug(() -> "Undoing JDK installation...");
        String jvmArg = (String)parameters.get("jvm");
        if (jvmArg == null) {
            undoStatus = Util.createError((String)NLS.bind((String)Messages.parameter_not_set, (Object)"jvm", (Object)ID));
        } else {
            String previous = (String)this.getMemento().get("previousValue");
            LauncherData launcherData = ((Manipulator)parameters.get("manipulator")).getLauncherData();
            File jvm = previous == null ? null : new File(previous);
            System.out.println("Undo: setting jvm " + jvm.getAbsolutePath());
            launcherData.setJvm(jvm);
            if (jvm != null) {
                SetJvmAction.adjustWorkbenchSystemProperties(jvm);
            }
        }
        return undoStatus;
    }

    private static void adjustWorkbenchSystemProperties(File jvm) {
        try {
            String eclipseCommands = System.getProperty("eclipse.commands");
            if (eclipseCommands != null) {
                String fullPath = jvm.getCanonicalPath();
                System.setProperty("eclipse.vm", fullPath);
                EclipseCommandsVM vm = new EclipseCommandsVM(eclipseCommands);
                if (vm.hasVM()) {
                    vm.replaceVM(fullPath);
                    System.setProperty("eclipse.commands", vm.getEclipseCommands());
                }
            }
        }
        catch (IOException iOException) {}
    }

    private static class EclipseCommandsVM {
        private static final String VM_ARG = "-vm";
        private static final char NEW_LINE = '\n';
        public static final String VM_WITH_LINE_FEED = "-vm\n";
        private int index1 = -1;
        private int index2 = -1;
        private String eclipseCommands;

        public EclipseCommandsVM(String eclipseCommands) {
            this.eclipseCommands = eclipseCommands;
            this.index1 = eclipseCommands.indexOf(VM_ARG);
            if (this.index1 != -1) {
                this.index2 = eclipseCommands.indexOf(10, this.index1 + VM_WITH_LINE_FEED.length());
            }
        }

        public int getIndex1() {
            return this.index1;
        }

        public int getIndex2() {
            return this.index2;
        }

        public boolean hasVM() {
            return this.index1 != -1;
        }

        public String getVM() {
            if (this.getIndex2() != -1) {
                return this.eclipseCommands.substring(this.getIndex1() + VM_WITH_LINE_FEED.length(), this.getIndex2());
            }
            return this.eclipseCommands.substring(this.getIndex1() + VM_WITH_LINE_FEED.length());
        }

        public void replaceVM(String vm) {
            if (this.getIndex2() == -1) {
                this.eclipseCommands = this.eclipseCommands.substring(0, this.getIndex1()) + VM_WITH_LINE_FEED + vm;
            } else {
                String tmp = this.eclipseCommands.substring(0, this.getIndex1()) + VM_WITH_LINE_FEED + vm;
                this.eclipseCommands = tmp + this.eclipseCommands.substring(this.getIndex2());
            }
        }

        public String getEclipseCommands() {
            return this.eclipseCommands;
        }
    }
}

