/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.activation.internal.classloader;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.artifact.ArtifactType;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.jpms.api.MuleContainerModule;
import org.mule.runtime.module.artifact.activation.api.ArtifactActivationException;
import org.mule.runtime.module.artifact.activation.api.classloader.ArtifactClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginClassLoaderResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginDescriptorResolver;
import org.mule.runtime.module.artifact.activation.internal.PluginsDependenciesProcessor;
import org.mule.runtime.module.artifact.activation.internal.classloader.MuleApplicationClassLoader;
import org.mule.runtime.module.artifact.activation.internal.classloader.MuleSharedDomainClassLoader;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinder;
import org.mule.runtime.module.artifact.activation.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.ChildFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ChildOnlyLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.DefaultArtifactClassLoaderFilter;
import org.mule.runtime.module.artifact.api.classloader.DelegateOnlyLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.DomainDescriptor;
import org.mule.runtime.module.artifact.internal.classloader.MulePluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArtifactClassLoaderResolver
implements ArtifactClassLoaderResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArtifactClassLoaderResolver.class);
    public static final String PLUGIN_CLASSLOADER_IDENTIFIER = "/plugin/";
    private final ArtifactClassLoader containerClassLoader;
    private final ModuleRepository moduleRepository;
    private final NativeLibraryFinderFactory nativeLibraryFinderFactory;

    public DefaultArtifactClassLoaderResolver(ArtifactClassLoader containerClassLoader, ModuleRepository moduleRepository, NativeLibraryFinderFactory nativeLibraryFinderFactory) {
        this.containerClassLoader = containerClassLoader;
        this.moduleRepository = moduleRepository;
        this.nativeLibraryFinderFactory = nativeLibraryFinderFactory;
    }

    @Override
    public ArtifactClassLoader getContainerClassLoader() {
        return this.containerClassLoader;
    }

    @Override
    public MuleDeployableArtifactClassLoader createDomainClassLoader(DomainDescriptor descriptor) {
        return this.createDomainClassLoader(descriptor, (ownerClassLoader, artifactPluginDescriptor) -> Optional.empty());
    }

    @Override
    public MuleDeployableArtifactClassLoader createDomainClassLoader(DomainDescriptor descriptor, PluginClassLoaderResolver pluginClassLoaderResolver) {
        return this.createDomainClassLoader(descriptor, pluginClassLoaderResolver, Collections.emptyList());
    }

    @Override
    public MuleDeployableArtifactClassLoader createDomainClassLoader(DomainDescriptor descriptor, PluginClassLoaderResolver pluginClassLoaderResolver, List<URL> additionalClassloaderUrls) {
        MuleSharedDomainClassLoader domainClassLoader;
        String artifactId = DefaultArtifactClassLoaderResolver.getDomainId(descriptor.getName());
        ClassLoaderLookupPolicy parentLookupPolicy = this.getDomainParentLookupPolicy(this.containerClassLoader);
        RegionClassLoader regionClassLoader = new RegionClassLoader(artifactId, (ArtifactDescriptor)descriptor, this.containerClassLoader.getClassLoader(), parentLookupPolicy);
        ArtifactClassLoaderFilter artifactClassLoaderFilter = this.createArtifactClassLoaderFilter((DeployableArtifactDescriptor)descriptor, parentLookupPolicy);
        if (descriptor.getName().equals("default")) {
            domainClassLoader = this.getDefaultDomainClassLoader((ArtifactClassLoader)regionClassLoader, regionClassLoader.getClassLoaderLookupPolicy());
        } else {
            NativeLibraryFinder nativeLibraryFinder = this.nativeLibraryFinderFactory.create(descriptor.getDataFolderName(), descriptor.getLoadedNativeLibrariesFolderName(), descriptor.getClassLoaderConfiguration().getUrls());
            domainClassLoader = this.getCustomDomainClassLoader((ArtifactClassLoader)regionClassLoader, descriptor, nativeLibraryFinder, additionalClassloaderUrls);
        }
        regionClassLoader.addClassLoader((ArtifactClassLoader)domainClassLoader, artifactClassLoaderFilter);
        List artifactPluginDescriptors = PluginsDependenciesProcessor.process(descriptor.getPlugins(), false, List::add);
        artifactPluginDescriptors.stream().map(pluginDependencyDescriptor -> pluginClassLoaderResolver.resolve((ArtifactClassLoader)domainClassLoader, (ArtifactPluginDescriptor)pluginDependencyDescriptor).orElse(() -> this.resolvePluginClassLoader((ArtifactClassLoader)domainClassLoader, (ArtifactPluginDescriptor)pluginDependencyDescriptor)).get()).forEach(artifactPluginClassLoader -> regionClassLoader.addClassLoader(artifactPluginClassLoader, this.createPluginClassLoaderFilter((DeployableArtifactDescriptor)descriptor, (ArtifactPluginDescriptor)artifactPluginClassLoader.getArtifactDescriptor(), parentLookupPolicy)));
        return domainClassLoader;
    }

    private MuleSharedDomainClassLoader getDefaultDomainClassLoader(ArtifactClassLoader parent, ClassLoaderLookupPolicy containerLookupPolicy) {
        return new MuleSharedDomainClassLoader((ArtifactDescriptor)new DomainDescriptor("default"), parent.getClassLoader(), containerLookupPolicy.extend(Collections.emptyMap()), Collections.emptyList());
    }

    private MuleSharedDomainClassLoader getCustomDomainClassLoader(ArtifactClassLoader parent, DomainDescriptor domain, NativeLibraryFinder nativeLibraryFinder, List<URL> additionalClassloaderUrls) {
        this.validateDomain(domain);
        List<URL> resourcesPath = Stream.concat(additionalClassloaderUrls.stream(), Arrays.stream(domain.getClassLoaderConfiguration().getUrls())).collect(Collectors.toList());
        return new MuleSharedDomainClassLoader((ArtifactDescriptor)domain, parent.getClassLoader(), this.getArtifactClassLoaderLookupPolicy(parent, (DeployableArtifactDescriptor)domain), resourcesPath, nativeLibraryFinder);
    }

    private void validateDomain(DomainDescriptor domainDescriptor) {
        File domainFolder = domainDescriptor.getRootFolder();
        if (!domainFolder.exists() || !domainFolder.isDirectory()) {
            throw new ArtifactActivationException(I18nMessageFactory.createStaticMessage((String)String.format("Domain %s does not exist", domainDescriptor.getName())));
        }
    }

    public static String getDomainId(String domainName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)domainName) ? 1 : 0) != 0, (String)"domainName cannot be empty");
        return "domain/" + domainName;
    }

    private ClassLoaderLookupPolicy getDomainParentLookupPolicy(ArtifactClassLoader parentClassLoader) {
        return parentClassLoader.getClassLoaderLookupPolicy();
    }

    @Override
    public MuleDeployableArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor descriptor) {
        return this.createApplicationClassLoader(descriptor, () -> this.containerClassLoader);
    }

    @Override
    public MuleDeployableArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor descriptor, PluginClassLoaderResolver pluginClassLoaderResolver) {
        return this.createApplicationClassLoader(descriptor, () -> this.containerClassLoader, pluginClassLoaderResolver);
    }

    @Override
    public MuleDeployableArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor descriptor, PluginClassLoaderResolver pluginClassLoaderResolver, List<URL> additionalClassloaderUrls) {
        return this.createApplicationClassLoader(descriptor, () -> this.containerClassLoader, pluginClassLoaderResolver, additionalClassloaderUrls);
    }

    @Override
    public MuleDeployableArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor descriptor, Supplier<ArtifactClassLoader> domainClassLoader) {
        return this.createApplicationClassLoader(descriptor, domainClassLoader, (ArtifactClassLoader ownerClassLoader, ArtifactPluginDescriptor artifactPluginDescriptor) -> Optional.empty());
    }

    @Override
    public MuleDeployableArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor descriptor, Supplier<ArtifactClassLoader> domainClassLoader, PluginClassLoaderResolver pluginClassLoaderResolver) {
        return this.createApplicationClassLoader(descriptor, domainClassLoader, pluginClassLoaderResolver, Collections.emptyList());
    }

    @Override
    public MuleDeployableArtifactClassLoader createApplicationClassLoader(ApplicationDescriptor descriptor, Supplier<ArtifactClassLoader> domainClassLoader, PluginClassLoaderResolver pluginClassLoaderResolver, List<URL> additionalClassloaderUrls) {
        ArtifactClassLoader parentClassLoader = domainClassLoader.get();
        String artifactId = DefaultArtifactClassLoaderResolver.getApplicationId(parentClassLoader.getArtifactId(), descriptor.getName());
        ClassLoaderLookupPolicy parentLookupPolicy = this.getApplicationParentLookupPolicy(parentClassLoader);
        RegionClassLoader regionClassLoader = new RegionClassLoader(artifactId, (ArtifactDescriptor)descriptor, parentClassLoader.getClassLoader(), parentLookupPolicy);
        ArtifactClassLoaderFilter artifactClassLoaderFilter = this.createArtifactClassLoaderFilter((DeployableArtifactDescriptor)descriptor, parentLookupPolicy);
        ClassLoaderLookupPolicy classLoaderLookupPolicy = this.getArtifactClassLoaderLookupPolicy(parentClassLoader, (DeployableArtifactDescriptor)descriptor);
        List<URL> resourcesPath = Stream.concat(additionalClassloaderUrls.stream(), Arrays.stream(descriptor.getClassLoaderConfiguration().getUrls())).collect(Collectors.toList());
        MuleApplicationClassLoader appClassLoader = new MuleApplicationClassLoader(artifactId, (ArtifactDescriptor)descriptor, (ClassLoader)regionClassLoader, this.nativeLibraryFinderFactory.create(descriptor.getDataFolderName(), descriptor.getLoadedNativeLibrariesFolderName(), descriptor.getClassLoaderConfiguration().getUrls()), resourcesPath, classLoaderLookupPolicy);
        regionClassLoader.addClassLoader((ArtifactClassLoader)appClassLoader, artifactClassLoaderFilter);
        List artifactPluginDescriptors = PluginsDependenciesProcessor.process(descriptor.getPlugins(), false, List::add);
        artifactPluginDescriptors.stream().map(pluginDependencyDescriptor -> pluginClassLoaderResolver.resolve((ArtifactClassLoader)appClassLoader, (ArtifactPluginDescriptor)pluginDependencyDescriptor).orElse(() -> this.resolvePluginClassLoader((ArtifactClassLoader)appClassLoader, (ArtifactPluginDescriptor)pluginDependencyDescriptor)).get()).forEach(artifactPluginClassLoader -> regionClassLoader.addClassLoader(artifactPluginClassLoader, this.createPluginClassLoaderFilter((DeployableArtifactDescriptor)descriptor, (ArtifactPluginDescriptor)artifactPluginClassLoader.getArtifactDescriptor(), parentLookupPolicy)));
        return appClassLoader;
    }

    private ClassLoaderLookupPolicy getApplicationParentLookupPolicy(ArtifactClassLoader parentClassLoader) {
        ArtifactDescriptor descriptor = parentClassLoader.getArtifactDescriptor();
        ArrayList packages = new ArrayList(descriptor.getClassLoaderConfiguration().getExportedPackages());
        if (descriptor instanceof DeployableArtifactDescriptor) {
            for (ArtifactPluginDescriptor artifactPluginDescriptor : ((DeployableArtifactDescriptor)descriptor).getPlugins()) {
                packages.addAll(artifactPluginDescriptor.getClassLoaderConfiguration().getExportedPackages());
            }
        }
        return parentClassLoader.getClassLoaderLookupPolicy().extend(packages.stream(), ParentFirstLookupStrategy.PARENT_FIRST);
    }

    public static String getApplicationId(String domainId, String applicationId) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)domainId) ? 1 : 0) != 0, (String)"domainId cannot be empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)applicationId) ? 1 : 0) != 0, (String)"applicationName cannot be empty");
        return domainId + "/app/" + applicationId;
    }

    private ClassLoaderLookupPolicy getArtifactClassLoaderLookupPolicy(ArtifactClassLoader parent, DeployableArtifactDescriptor descriptor) {
        ArrayList packages = new ArrayList();
        for (ArtifactPluginDescriptor artifactPluginDescriptor : descriptor.getPlugins()) {
            packages.addAll(artifactPluginDescriptor.getClassLoaderConfiguration().getExportedPackages());
        }
        return parent.getClassLoaderLookupPolicy().extend(packages.stream(), ParentFirstLookupStrategy.PARENT_FIRST);
    }

    private ArtifactClassLoaderFilter createArtifactClassLoaderFilter(DeployableArtifactDescriptor artifactDescriptor, ClassLoaderLookupPolicy classLoaderLookupPolicy) {
        Set<String> artifactExportedPackages = this.sanitizeExportedPackages(artifactDescriptor, classLoaderLookupPolicy, artifactDescriptor.getClassLoaderConfiguration().getExportedPackages());
        return new DefaultArtifactClassLoaderFilter(artifactExportedPackages, artifactDescriptor.getClassLoaderConfiguration().getExportedResources());
    }

    private ArtifactClassLoaderFilter createPluginClassLoaderFilter(DeployableArtifactDescriptor artifactDescriptor, ArtifactPluginDescriptor pluginDescriptor, ClassLoaderLookupPolicy classLoaderLookupPolicy) {
        Set<String> sanitizedArtifactExportedPackages = this.sanitizeExportedPackages(artifactDescriptor, classLoaderLookupPolicy, pluginDescriptor.getClassLoaderConfiguration().getExportedPackages());
        Set replacedPackages = artifactDescriptor.getClassLoaderConfiguration().getExportedPackages().stream().filter(p -> sanitizedArtifactExportedPackages.contains(p)).collect(Collectors.toSet());
        if (!replacedPackages.isEmpty()) {
            sanitizedArtifactExportedPackages.removeAll(replacedPackages);
            LOGGER.warn("Exported packages from plugin '" + pluginDescriptor.getName() + "' are provided by the artifact owner: " + String.valueOf(replacedPackages));
        }
        return new DefaultArtifactClassLoaderFilter(sanitizedArtifactExportedPackages, pluginDescriptor.getClassLoaderConfiguration().getExportedResources());
    }

    private Set<String> sanitizeExportedPackages(DeployableArtifactDescriptor artifactDescriptor, ClassLoaderLookupPolicy classLoaderLookupPolicy, Set<String> artifactExportedPackages) {
        HashSet<String> sanitizedArtifactExportedPackages = new HashSet<String>(artifactExportedPackages);
        Set containerProvidedPackages = sanitizedArtifactExportedPackages.stream().filter(p -> {
            LookupStrategy lookupStrategy = classLoaderLookupPolicy.getPackageLookupStrategy(p);
            return !(lookupStrategy instanceof ChildFirstLookupStrategy);
        }).collect(Collectors.toSet());
        if (!containerProvidedPackages.isEmpty()) {
            sanitizedArtifactExportedPackages.removeAll(containerProvidedPackages);
            LOGGER.warn("Exported packages from artifact '" + artifactDescriptor.getName() + "' are provided by parent class loader: " + String.valueOf(containerProvidedPackages));
        }
        return sanitizedArtifactExportedPackages;
    }

    @Override
    public MuleArtifactClassLoader createMulePluginClassLoader(MuleDeployableArtifactClassLoader ownerArtifactClassLoader, ArtifactPluginDescriptor descriptor, PluginDescriptorResolver pluginDescriptorResolver) {
        return this.createMulePluginClassLoader(ownerArtifactClassLoader, descriptor, pluginDescriptorResolver, (ownerClassLoader, artifactPluginDescriptor) -> Optional.empty());
    }

    @Override
    public MuleArtifactClassLoader createMulePluginClassLoader(MuleDeployableArtifactClassLoader ownerArtifactClassLoader, ArtifactPluginDescriptor descriptor, PluginDescriptorResolver pluginDescriptorResolver, PluginClassLoaderResolver pluginClassLoaderResolver) {
        RegionClassLoader regionClassLoader = (RegionClassLoader)ownerArtifactClassLoader.getParent();
        String pluginArtifactId = this.getArtifactPluginId(regionClassLoader.getArtifactId(), descriptor.getName());
        ClassLoaderLookupPolicy pluginLookupPolicy = this.createPluginLookupPolicy(descriptor, ownerArtifactClassLoader, pluginDescriptorResolver, pluginClassLoaderResolver);
        MulePluginClassLoader pluginClassLoader = new MulePluginClassLoader(pluginArtifactId, descriptor, descriptor.getClassLoaderConfiguration().getUrls(), (ClassLoader)regionClassLoader, pluginLookupPolicy);
        return pluginClassLoader;
    }

    protected ClassLoaderLookupPolicy createPluginLookupPolicy(ArtifactPluginDescriptor descriptor, MuleDeployableArtifactClassLoader ownerArtifactClassLoader, PluginDescriptorResolver pluginDescriptorResolver, PluginClassLoaderResolver pluginClassLoaderResolver) {
        RegionClassLoader regionClassLoader = (RegionClassLoader)ownerArtifactClassLoader.getParent();
        ClassLoaderLookupPolicy baseLookupPolicy = regionClassLoader.getClassLoaderLookupPolicy().extend(regionClassLoader.filterForClassLoader(regionClassLoader.getOwnerClassLoader()).getExportedClassPackages().stream(), ParentFirstLookupStrategy.PARENT_FIRST);
        Set pluginsDescriptors = ownerArtifactClassLoader.getArtifactPluginClassLoaders().stream().map(p -> (ArtifactPluginDescriptor)p.getArtifactDescriptor()).collect(Collectors.toSet());
        HashMap<String, LookupStrategy> pluginsLookupPolicies = new HashMap<String, LookupStrategy>();
        descriptor.getClassLoaderConfiguration().getDependencies().stream().filter(dependency -> dependency.getDescriptor().getClassifier().map(ArtifactType.PLUGIN.getMavenArtifactClassifier()::equals).orElse(false)).map(dependency -> pluginDescriptorResolver.resolve(pluginsDescriptors, dependency.getDescriptor())).filter(Optional::isPresent).map(Optional::get).forEach(dependencyPluginDescriptor -> {
            for (String exportedPackage : dependencyPluginDescriptor.getClassLoaderConfiguration().getExportedPackages()) {
                pluginsLookupPolicies.put(exportedPackage, ParentFirstLookupStrategy.PARENT_FIRST);
            }
            if (this.isPrivilegedPluginDependency(descriptor, (ArtifactPluginDescriptor)dependencyPluginDescriptor)) {
                ArtifactClassLoader pluginClassLoader = pluginClassLoaderResolver.resolve(regionClassLoader.getOwnerClassLoader(), (ArtifactPluginDescriptor)dependencyPluginDescriptor).orElse(() -> regionClassLoader.getArtifactPluginClassLoaders().stream().filter(c -> c.getArtifactDescriptor().getBundleDescriptor().getArtifactId().equals(dependencyPluginDescriptor.getBundleDescriptor().getArtifactId())).findAny().orElseThrow(() -> new ArtifactActivationException(I18nMessageFactory.createStaticMessage((String)("Cannot find classloader for plugin: " + dependencyPluginDescriptor.getBundleDescriptor().getArtifactId()))))).get();
                DelegateOnlyLookupStrategy lookupStrategy = new DelegateOnlyLookupStrategy(pluginClassLoader.getClassLoader());
                for (String exportedPackage : dependencyPluginDescriptor.getClassLoaderConfiguration().getPrivilegedExportedPackages()) {
                    pluginsLookupPolicies.put(exportedPackage, (LookupStrategy)lookupStrategy);
                }
            }
        });
        LookupStrategy containerOnlyLookupStrategy = this.containerClassLoader.getClassLoaderLookupPolicy().getClassLookupStrategy(ModuleRepository.class.getName());
        HashSet muleModulesExportedPackages = new HashSet();
        for (MuleContainerModule module : this.moduleRepository.getModules()) {
            if (module.getPrivilegedArtifacts().contains(descriptor.getBundleDescriptor().getGroupId() + ":" + descriptor.getBundleDescriptor().getArtifactId())) {
                for (String packageName : module.getPrivilegedExportedPackages()) {
                    pluginsLookupPolicies.put(packageName, containerOnlyLookupStrategy);
                }
            }
            muleModulesExportedPackages.addAll(module.getExportedPackages());
        }
        ArrayList<String> pluginLocalPackages = new ArrayList<String>();
        for (String localPackage : descriptor.getClassLoaderConfiguration().getLocalPackages()) {
            if (baseLookupPolicy.getPackageLookupStrategy(localPackage) instanceof ContainerOnlyLookupStrategy || baseLookupPolicy.getPackageLookupStrategy(localPackage) instanceof ParentFirstLookupStrategy && muleModulesExportedPackages.contains(localPackage)) {
                LOGGER.debug("Plugin '" + descriptor.getName() + "' contains a local package '" + localPackage + "', but it will be ignored since it is already available from the container.");
                continue;
            }
            pluginLocalPackages.add(localPackage);
        }
        return baseLookupPolicy.extend(pluginsLookupPolicies).extend(pluginLocalPackages.stream(), ChildOnlyLookupStrategy.CHILD_ONLY, true);
    }

    private String getArtifactPluginId(String parentArtifactId, String pluginName) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)parentArtifactId) ? 1 : 0) != 0, (String)"parentArtifactId cannot be empty");
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)pluginName) ? 1 : 0) != 0, (String)"pluginName cannot be empty");
        return parentArtifactId + PLUGIN_CLASSLOADER_IDENTIFIER + pluginName;
    }

    private boolean isPrivilegedPluginDependency(ArtifactPluginDescriptor descriptor, ArtifactPluginDescriptor dependencyPluginDescriptor) {
        if (dependencyPluginDescriptor.getClassLoaderConfiguration().getPrivilegedExportedPackages().isEmpty()) {
            return false;
        }
        return dependencyPluginDescriptor.getClassLoaderConfiguration().getPrivilegedArtifacts().stream().filter(a -> a.startsWith(descriptor.getBundleDescriptor().getGroupId() + ":" + descriptor.getBundleDescriptor().getArtifactId())).findFirst().isPresent();
    }

    private MuleArtifactClassLoader resolvePluginClassLoader(ArtifactClassLoader ownerClassLoader, ArtifactPluginDescriptor descriptor) {
        return this.createMulePluginClassLoader((MuleDeployableArtifactClassLoader)ownerClassLoader, descriptor, PluginDescriptorResolver.pluginDescriptorResolver());
    }
}

