/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;

@NoExtend
public abstract class AbstractRedeliveryPolicy
extends AbstractMessageProcessorOwner
implements Scope {
    private List<Processor> processors;
    protected MessageProcessorChain nestedChain;
    protected int maxRedeliveryCount;
    public static final int REDELIVERY_FAIL_ON_FIRST = 0;

    public void initialise() throws InitialisationException {
        if (this.maxRedeliveryCount < 0) {
            throw new InitialisationException(CoreMessages.initialisationFailure((String)"maxRedeliveryCount must be positive"), (Initialisable)this);
        }
        this.nestedChain = MessageProcessors.buildNewChainWithListOfProcessors((Optional)MessageProcessors.getProcessingStrategy((ConfigurationComponentLocator)this.locator, (Component)this), this.processors, (FlowExceptionHandler)NullExceptionHandler.getInstance(), (String)this.getLocation().getLocation());
        super.initialise();
    }

    public int getMaxRedeliveryCount() {
        return this.maxRedeliveryCount;
    }

    public void setMaxRedeliveryCount(int maxRedeliveryCount) {
        this.maxRedeliveryCount = maxRedeliveryCount;
    }

    public void setMessageProcessors(List<Processor> processors) {
        this.processors = processors;
    }

    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.nestedChain);
    }
}

