/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.http.custom;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.ui.modules.core.widgets.meta.AfterSaveCorrection;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributesPersistenceTransformer;

public class HTTPPathOrUrlPersistenceTransformer
implements AttributesPersistenceTransformer,
AfterSaveCorrection {
    private static final String AUXILIARY_ERASED = "auxiliary;erased;";
    private static final String URL_ATTR = "url";
    private static final String PATH_ATTR = "path";
    private static final String CONFIG_REF_ATTR = "config-ref";

    public void afterSave(IMessageFlowNode node, PropertyCollectionMap props) {
        String pathAttr = props.getProperty(PATH_ATTR, "");
        if (this.isURL(pathAttr)) {
            props.addProperty(URL_ATTR, pathAttr);
            props.addProperty("auxiliary;erased;path", "true");
            props.removeProperty("auxiliary;erased;url");
            if (StringUtils.isBlank((CharSequence)props.getProperty(CONFIG_REF_ATTR, ""))) {
                props.addProperty("auxiliary;erased;config-ref", "true");
            }
            return;
        }
        node.getElement().removeAttribute(URL_ATTR);
        node.getPropertiesForEdit(null).removeProperty(URL_ATTR);
        props.removeProperty("auxiliary;erased;path");
        props.removeProperty("auxiliary;erased;config-ref");
    }

    public void onLoad(IMessageFlowNode node, PropertyCollectionMap props) {
        String attrValue = props.getProperty(URL_ATTR, "");
        if (!StringUtils.isBlank((CharSequence)attrValue)) {
            props.addProperty(PATH_ATTR, attrValue);
            props.removeProperty("auxiliary;erased;path");
            props.removeProperty("auxiliary;erased;config-ref");
        }
    }

    private boolean isURL(String path) {
        try {
            URL urlFromPath = new URL(path);
            return urlFromPath.getProtocol().toLowerCase().startsWith("http");
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public void onSave(IMessageFlowNode node, PropertyCollectionMap props) {
    }
}

