/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.http.custom;

import com.onpositive.commons.namespace.ide.ui.editors.xml.model.DomainEditingModelObject;
import com.onpositive.commons.namespace.ide.ui.internal.core.text.IDocumentAttributeNode;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.dom.INodeListWrapper;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.MessageBuilder;
import org.mule.tooling.core.validation.ValidationConstants;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.GlobalRefEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.StringFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.IComponentValidator;
import org.mule.tooling.ui.modules.http.custom.HttpCustomDesc;

public class HTTPConfigURLValidator
implements IComponentValidator {
    private static final String ERROR_NO_HOST_VALUE = "No host value provided";
    public static final String ERROR_URL_CONFIG = "You need to create an HTTP Request configuration or configure an URL";
    public static final String ERROR_PATH_REQUIRED = "Attribute 'path' is required if 'url' is not set";
    public static final String CONFIG_REF_ATTR = "config-ref";
    public static final String URL_ATTR = "url";
    public static final String PATH_ATTR = "path";
    private static final String HTTP_CONFIG_TYPE = "http:request-config";

    public Message validateComponent(DomainEditingModelObject pNode) {
        IDocumentAttributeNode[] attributesArray;
        String urlValue = "";
        String configrefValue = "";
        String pathValue = "";
        IDocumentAttributeNode[] iDocumentAttributeNodeArray = attributesArray = pNode.getNodeAttributes();
        int n = attributesArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDocumentAttributeNode attribute = iDocumentAttributeNodeArray[n2];
            if (URL_ATTR.equals(attribute.getAttributeName())) {
                urlValue = attribute.getAttributeValue();
            }
            if (PATH_ATTR.equals(attribute.getAttributeName())) {
                pathValue = attribute.getAttributeValue();
            }
            if (CONFIG_REF_ATTR.equals(attribute.getAttributeName())) {
                configrefValue = attribute.getAttributeValue();
            }
            ++n2;
        }
        if (StringUtils.isNotBlank((CharSequence)configrefValue) && StringUtils.isBlank((CharSequence)urlValue) && StringUtils.isBlank((CharSequence)pathValue)) {
            return MessageBuilder.newErrorMessage((String)ERROR_PATH_REQUIRED).build();
        }
        if (StringUtils.isNotBlank((CharSequence)configrefValue) || StringUtils.isNotBlank((CharSequence)urlValue)) {
            return ValidationConstants.MESSAGE_OK;
        }
        return MessageBuilder.newErrorMessage((String)ERROR_URL_CONFIG).build();
    }

    public Message validateComponentGUI(IMessageFlowNode node, List<IFieldEditor> editors) {
        HttpCustomDesc customDescEditor = null;
        GlobalRefEditor globalRefEditor = null;
        String urlFieldValue = "";
        String globalUrlValue = "";
        String globalRefValue = "";
        String pathValue = "";
        Message message = ValidationConstants.MESSAGE_OK;
        for (IFieldEditor editor : editors) {
            if (editor instanceof HttpCustomDesc) {
                customDescEditor = (HttpCustomDesc)editor;
                continue;
            }
            if (editor instanceof GlobalRefEditor) {
                globalRefEditor = (GlobalRefEditor)editor;
                globalRefValue = globalRefEditor.getValue();
                continue;
            }
            if (!(editor instanceof StringFieldEditor)) continue;
            StringFieldEditor stringFieldEditor = (StringFieldEditor)editor;
            if (URL_ATTR.equals(stringFieldEditor.getHelper().getId())) {
                urlFieldValue = stringFieldEditor.getValue();
            }
            if (!PATH_ATTR.equals(stringFieldEditor.getHelper().getId())) continue;
            pathValue = stringFieldEditor.getValue();
        }
        if (StringUtils.isBlank((CharSequence)urlFieldValue) && StringUtils.isBlank((CharSequence)pathValue)) {
            message = MessageBuilder.newErrorMessage((String)ERROR_PATH_REQUIRED).build();
        }
        globalUrlValue = this.findURLInConfig(globalRefEditor, pathValue);
        if (StringUtils.isNotBlank((CharSequence)globalRefValue)) {
            this.updateLabel(customDescEditor, globalUrlValue);
            if (globalUrlValue.equals(ERROR_NO_HOST_VALUE) || globalUrlValue.equals(ERROR_URL_CONFIG)) {
                message = MessageBuilder.newErrorMessage((String)globalUrlValue).build();
            }
        } else if (StringUtils.isNotBlank((CharSequence)urlFieldValue)) {
            this.updateLabel(customDescEditor, urlFieldValue);
        } else {
            this.updateLabel(customDescEditor, ERROR_URL_CONFIG);
            message = MessageBuilder.newErrorMessage((String)ERROR_URL_CONFIG).build();
        }
        return message;
    }

    private void updateLabel(HttpCustomDesc editor, String description) {
        if (editor != null && !editor.isDisposed()) {
            editor.setDescription(description);
        }
    }

    private String findURLInConfig(GlobalRefEditor editor, String path) {
        return this.findURLInConfig(editor.getContext(), editor.getValue(), path);
    }

    private String findURLInConfig(AttributeContext context, String selected, String path) {
        String httpDesc = "";
        List actualGlobals = GlobalRefEditor.getActualGlobals((AttributeContext)context);
        for (IMessageFlowEntity entry : actualGlobals) {
            IElementWrapper candidate = entry.getElement();
            if (!candidate.getTagName().equals(HTTP_CONFIG_TYPE)) continue;
            IAttributeWrapper basePathAttr = candidate.getAttribute("basePath");
            if (!candidate.getAttribute("name").getText().equals(selected)) continue;
            INodeListWrapper children = candidate.getChildElements();
            httpDesc = ERROR_NO_HOST_VALUE;
            for (IElementWrapper child : children) {
                if (!child.getName().equals("request-connection")) continue;
                httpDesc = this.buildUrlFromGlobal(basePathAttr, child, path);
                break;
            }
            return httpDesc;
        }
        return ERROR_URL_CONFIG;
    }

    private String buildUrlFromGlobal(IAttributeWrapper basePathAttr, IElementWrapper element, String path) {
        String port;
        IAttributeWrapper hostAttr = element.getAttribute("host");
        IAttributeWrapper portAttr = element.getAttribute("port");
        IAttributeWrapper protocolAttr = element.getAttribute("protocol");
        StringBuilder descBuilder = new StringBuilder();
        if (protocolAttr == null) {
            descBuilder.append("http://");
        } else {
            descBuilder.append(protocolAttr.getText() + "://");
        }
        if (hostAttr != null) {
            descBuilder.append(hostAttr.getText());
        } else {
            descBuilder.append("localhost");
        }
        if (!(portAttr == null || (port = portAttr.getText()).equals("-1") && port.equals("80") && port.equals("433"))) {
            descBuilder.append(":").append(port);
        }
        if (basePathAttr != null && !basePathAttr.getText().equals("/")) {
            descBuilder.append(basePathAttr.getText());
        }
        descBuilder.append(path);
        return descBuilder.toString();
    }
}

