/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.runtime.configuration;

import com.google.common.collect.ImmutableList;
import com.google.inject.Singleton;
import com.mulesoft.agent.domain.runtime.configuration.RemoteRepositoryInfo;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.RuntimeConfigurationService;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.globalconfig.api.GlobalConfigLoader;

@Named(value="mule.agent.runtime.configuration.service")
@Singleton
public class MuleRuntimeConfigurationService
extends ConfigurableAgentService
implements RuntimeConfigurationService {
    public void setConfiguration(Map<String, String> configurationEntries) {
        configurationEntries.entrySet().forEach(entry -> System.setProperty((String)entry.getKey(), (String)entry.getValue()));
        GlobalConfigLoader.reset();
    }

    public Set<RemoteRepositoryInfo> getMavenRepositories() {
        return GlobalConfigLoader.getMavenConfig().getMavenRemoteRepositories().stream().map(repository -> {
            RemoteRepositoryInfo.RemoteRepositoryInfoBuilder builder = new RemoteRepositoryInfo.RemoteRepositoryInfoBuilder();
            builder.withId(repository.getId());
            builder.withUrl(repository.getUrl().toExternalForm());
            repository.getAuthentication().ifPresent(authentication -> builder.withAuthentication());
            return builder.build();
        }).collect(Collectors.toSet());
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return ImmutableList.of();
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }
}

