/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.AbstractTemporalConverter;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;

public final class LocalTimeConverter
extends AbstractTemporalConverter {
    public static final LocalTimeConverter INSTANCE = new LocalTimeConverter();

    private LocalTimeConverter() {
        super(14, QueryDataTypeFamily.TIME);
    }

    @Override
    public Class<?> getValueClass() {
        return LocalTime.class;
    }

    @Override
    public String asVarchar(Object val) {
        return this.cast(val).toString();
    }

    @Override
    public LocalTime asTime(Object val) {
        return this.cast(val);
    }

    @Override
    public LocalDateTime asTimestamp(Object val) {
        LocalTime time = this.cast(val);
        return LocalTimeConverter.timeToTimestamp(time);
    }

    @Override
    public OffsetDateTime asTimestampWithTimezone(Object val) {
        LocalTime time = this.cast(val);
        LocalDateTime timestamp = LocalTimeConverter.timeToTimestamp(time);
        return LocalTimeConverter.timestampToTimestampWithTimezone(timestamp);
    }

    @Override
    public Object convertToSelf(Converter valConverter, Object val) {
        return valConverter.asTime(val);
    }

    private LocalTime cast(Object val) {
        return (LocalTime)val;
    }
}

