/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.row;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.JetDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.sql.impl.row.Row;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;

public class JetSqlRow
implements IdentifiedDataSerializable {
    private SerializationService ss;
    private Object[] values;

    public JetSqlRow() {
    }

    public JetSqlRow(@Nonnull SerializationService ss, @Nonnull Object[] values) {
        this.ss = ss;
        this.values = values;
    }

    public Object get(int index) {
        this.values[index] = this.ss.toObject(this.values[index]);
        return this.values[index];
    }

    public Data getSerialized(int index) {
        this.values[index] = this.ss.toData(this.values[index]);
        return (Data)this.values[index];
    }

    public Object getMaybeSerialized(int index) {
        return this.values[index];
    }

    public int getFieldCount() {
        return this.values.length;
    }

    public Object[] getValues() {
        return this.values;
    }

    public SerializationService getSerializationService() {
        return this.ss;
    }

    public Row getRow() {
        return new Row(){

            @Override
            public <T> T get(int index) {
                return (T)JetSqlRow.this.get(index);
            }

            @Override
            public int getColumnCount() {
                return JetSqlRow.this.getFieldCount();
            }
        };
    }

    public JetSqlRow extendedRow(int extendBy) {
        assert (extendBy > -1);
        return extendBy == 0 ? this : new JetSqlRow(this.ss, Arrays.copyOf(this.values, this.values.length + extendBy));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JetSqlRow jetSqlRow = (JetSqlRow)o;
        for (int i = 0; i < this.values.length; ++i) {
            if (Objects.equals(this.getSerialized(i), jetSqlRow.getSerialized(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    @Override
    public int getFactoryId() {
        return JetDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 6;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.values.length);
        for (Object value : this.values) {
            IOUtil.writeData(out, this.ss.toData(value));
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.ss = ((SerializationServiceSupport)((Object)in)).getSerializationService();
        this.values = new Object[in.readInt()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = IOUtil.readData(in);
        }
    }
}

