/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;

public final class ParameterExpression<T>
implements Expression<T>,
IdentifiedDataSerializable {
    private int index;
    private QueryDataType type;

    public ParameterExpression() {
    }

    private ParameterExpression(int index, QueryDataType type) {
        this.index = index;
        this.type = type;
    }

    public static ParameterExpression<?> create(int index, QueryDataType type) {
        return new ParameterExpression(index, type);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 15;
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        return (T)context.getArgument(this.index);
    }

    @Override
    public QueryDataType getType() {
        return this.type;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.index);
        out.writeObject(this.type);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.index = in.readInt();
        this.type = (QueryDataType)in.readObject();
    }

    public int hashCode() {
        int result = this.index;
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterExpression that = (ParameterExpression)o;
        return this.index == that.index && this.type.equals(that.type);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{index=" + this.index + '}';
    }
}

