/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.operation;

import com.hazelcast.jet.Util;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.execution.ExecutionContext;
import com.hazelcast.jet.impl.operation.AsyncJobOperation;
import com.hazelcast.jet.impl.util.LoggingUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;

public class SnapshotPhase2Operation
extends AsyncJobOperation {
    private static final CompletableFuture<Void> EMPTY_RESULT = CompletableFuture.completedFuture(null);
    private long executionId;
    private long snapshotId;
    private boolean success;

    public SnapshotPhase2Operation() {
    }

    public SnapshotPhase2Operation(long jobId, long executionId, long snapshotId, boolean success) {
        super(jobId);
        this.executionId = executionId;
        this.snapshotId = snapshotId;
        this.success = success;
    }

    protected CompletableFuture<Void> doRun() {
        JetServiceBackend service = this.getJetServiceBackend();
        ExecutionContext ctx = service.getJobExecutionService().assertExecutionContext(this.getCallerAddress(), this.jobId(), this.executionId, this.getClass().getSimpleName());
        assert (!ctx.isLightJob()) : "snapshot phase 2 started on a light job: " + Util.idToString(this.executionId);
        return ctx.beginSnapshotPhase2(this.snapshotId, this.success).whenComplete((r, t) -> {
            if (t != null) {
                this.getLogger().warning(String.format("Snapshot %d phase 2 for %s finished with an error on member: %s", this.snapshotId, ctx.jobNameAndExecutionId(), t), (Throwable)t);
            } else {
                LoggingUtil.logFine(this.getLogger(), "Snapshot %s phase 2 for %s finished successfully on member", this.snapshotId, ctx.jobNameAndExecutionId());
            }
        });
    }

    @Override
    public int getClassId() {
        return 36;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.executionId);
        out.writeLong(this.snapshotId);
        out.writeBoolean(this.success);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.executionId = in.readLong();
        this.snapshotId = in.readLong();
        this.success = in.readBoolean();
    }
}

