/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.internal.serialization.DataSerializerHook;
import com.hazelcast.internal.serialization.impl.FactoryIdHelper;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.aggregate.AggregateOperation1Impl;
import com.hazelcast.jet.impl.connector.AbstractUpdateMapP;
import com.hazelcast.jet.impl.connector.HazelcastReaders;
import com.hazelcast.jet.impl.connector.ReadMapOrCacheP;
import com.hazelcast.jet.impl.connector.UpdateMapP;
import com.hazelcast.jet.impl.processor.ProcessorSuppliers;
import com.hazelcast.jet.pipeline.test.impl.ItemsDistributedFillBufferFn;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.sql.impl.row.JetSqlRow;

@PrivateApi
public final class JetDataSerializerHook
implements DataSerializerHook {
    public static final int DAG = 0;
    public static final int VERTEX = 1;
    public static final int EDGE = 2;
    public static final int APPLY_FN_ENTRY_PROCESSOR = 3;
    public static final int APPLY_VALUE_ENTRY_PROCESSOR = 4;
    public static final int TEST_SOURCES_ITEMS_DISTRIBUTED_FILL_BUFFER_FN = 5;
    public static final int JET_SQL_ROW = 6;
    public static final int LOCAL_MAP_READER_FUNCTION = 7;
    public static final int PROCESSORS_AGGREGATE_P_SUPPLIER = 8;
    public static final int LOCAL_CACHE_READER_FUNCTION = 9;
    public static final int REMOTE_CACHE_READER_FUNCTION = 10;
    public static final int LOCAL_MAP_QUERY_READER_FUNCTION = 11;
    public static final int REMOTE_MAP_READER_FUNCTION = 12;
    public static final int REMOTE_MAP_QUERY_READER_FUNCTION = 13;
    public static final int READ_MAP_OR_CACHE_P_LOCAL_PROCESSOR_SUPPLIER = 14;
    public static final int PROCESSOR_MAP_P_SUPPLIER = 15;
    public static final int AGGREGATE_COMBINING_ACCUMULATE = 16;
    public static final int EDGE_KEY_PARTITIONER = 17;
    public static final int EDGE_SINGLE_PARTITIONER = 18;
    public static final int EXPECT_NOTHING_PROCESSOR_SUPPLIER = 19;
    public static final int SPECIFIC_MEMBER_PROCESSOR_META_SUPPLIER = 20;
    public static final int FACTORY_ID = FactoryIdHelper.getFactoryId("hazelcast.serialization.ds.jet", -10001);

    @Override
    public int getFactoryId() {
        return FACTORY_ID;
    }

    @Override
    public DataSerializableFactory createFactory() {
        return new Factory();
    }

    private static class Factory
    implements DataSerializableFactory {
        private Factory() {
        }

        @Override
        public IdentifiedDataSerializable create(int typeId) {
            switch (typeId) {
                case 0: {
                    return new DAG();
                }
                case 1: {
                    return new Vertex();
                }
                case 2: {
                    return new Edge();
                }
                case 3: {
                    return new UpdateMapP.ApplyFnEntryProcessor();
                }
                case 4: {
                    return new AbstractUpdateMapP.ApplyValuesEntryProcessor();
                }
                case 5: {
                    return new ItemsDistributedFillBufferFn();
                }
                case 6: {
                    return new JetSqlRow();
                }
                case 7: {
                    return new HazelcastReaders.LocalMapReaderFunction();
                }
                case 8: {
                    return new ProcessorSuppliers.AggregatePSupplier();
                }
                case 9: {
                    return new HazelcastReaders.LocalCacheReaderFunction();
                }
                case 10: {
                    return new HazelcastReaders.RemoteCacheReaderFunction();
                }
                case 11: {
                    return new HazelcastReaders.LocalMapQueryReaderFunction();
                }
                case 12: {
                    return new HazelcastReaders.RemoteMapReaderFunction();
                }
                case 13: {
                    return new HazelcastReaders.RemoteMapQueryReaderFunction();
                }
                case 14: {
                    return new ReadMapOrCacheP.LocalProcessorSupplier();
                }
                case 15: {
                    return new ProcessorSuppliers.ProcessorMapPSupplier();
                }
                case 16: {
                    return new AggregateOperation1Impl.AggregateCombiningAccumulate();
                }
                case 17: {
                    return new Edge.KeyPartitioner();
                }
                case 18: {
                    return new Edge.Single();
                }
                case 19: {
                    return new ProcessorMetaSupplier.ExpectNothingProcessorSupplier();
                }
                case 20: {
                    return new ProcessorMetaSupplier.SpecificMemberPms();
                }
            }
            throw new IllegalArgumentException("Unknown type id " + typeId);
        }
    }
}

