/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.datastore.impl;

import com.hazelcast.config.ExternalDataStoreConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.datastore.ExternalDataStoreFactory;
import com.hazelcast.datastore.ExternalDataStoreService;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ExternalDataStoreServiceImpl
implements ExternalDataStoreService {
    private final Map<String, ExternalDataStoreFactory<?>> dataStoreFactories = new ConcurrentHashMap();
    private final ClassLoader classLoader;
    private final Node node;
    private final ILogger logger;

    public ExternalDataStoreServiceImpl(Node node, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.node = node;
        this.logger = node.getLogger(ExternalDataStoreServiceImpl.class);
        for (Map.Entry<String, ExternalDataStoreConfig> entry : node.getConfig().getExternalDataStoreConfigs().entrySet()) {
            this.dataStoreFactories.put(entry.getKey(), this.createFactory(entry.getValue()));
        }
    }

    private <DS> ExternalDataStoreFactory<DS> createFactory(ExternalDataStoreConfig config) {
        this.logger.finest("Creating '" + config.getName() + "' external datastore factory");
        String className = config.getClassName();
        try {
            ExternalDataStoreFactory externalDataStoreFactory = (ExternalDataStoreFactory)ClassLoaderUtil.newInstance(this.classLoader, className);
            externalDataStoreFactory.init(config);
            return externalDataStoreFactory;
        }
        catch (ClassCastException e) {
            throw new HazelcastException("External data store '" + config.getName() + "' misconfigured: '" + className + "' must implement '" + ExternalDataStoreFactory.class.getName() + "'", e);
        }
        catch (ClassNotFoundException e) {
            throw new HazelcastException("External data store '" + config.getName() + "' misconfigured: class '" + className + "' not found", e);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public <DS> ExternalDataStoreFactory<DS> getExternalDataStoreFactory(String name) {
        ExternalDataStoreConfig externalDataStoreConfig = this.node.getConfig().getExternalDataStoreConfigs().get(name);
        if (externalDataStoreConfig == null) {
            throw new HazelcastException("External data store factory '" + name + "' not found");
        }
        return this.dataStoreFactories.computeIfAbsent(name, n -> this.createFactory(externalDataStoreConfig));
    }

    @Override
    public void close() {
        for (Map.Entry<String, ExternalDataStoreFactory<?>> entry : this.dataStoreFactories.entrySet()) {
            try {
                this.logger.finest("Closing '" + entry.getKey() + "' external datastore factory");
                ExternalDataStoreFactory<?> dataStoreFactory = entry.getValue();
                dataStoreFactory.close();
            }
            catch (Exception e) {
                this.logger.warning("Closing '" + entry.getKey() + "' external datastore factory failed", e);
            }
        }
    }
}

