/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.connection.tcp;

import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.fd.PingFailureDetector;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ICMPHelper;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public final class ClientICMPManager {
    private static final long MIN_ICMP_INTERVAL_MILLIS = TimeUnit.SECONDS.toMillis(1L);

    private ClientICMPManager() {
    }

    public static void start(ClientIcmpPingConfig clientIcmpPingConfig, TaskScheduler taskScheduler, ILogger logger, Collection<Connection> unmodifiableActiveConnections) {
        if (!clientIcmpPingConfig.isEnabled()) {
            return;
        }
        if (clientIcmpPingConfig.isEchoFailFastOnStartup()) {
            ClientICMPManager.echoFailFast(logger);
        }
        int icmpTtl = clientIcmpPingConfig.getTtl();
        int icmpTimeoutMillis = clientIcmpPingConfig.getTimeoutMilliseconds();
        int icmpIntervalMillis = clientIcmpPingConfig.getIntervalMilliseconds();
        int icmpMaxAttempts = clientIcmpPingConfig.getMaxAttempts();
        if (icmpTimeoutMillis > icmpIntervalMillis) {
            throw new IllegalStateException("ICMP timeout is set to a value greater than the ICMP interval, this is not allowed.");
        }
        if ((long)icmpIntervalMillis < MIN_ICMP_INTERVAL_MILLIS) {
            throw new IllegalStateException("ICMP interval is set to a value less than the min allowed, " + MIN_ICMP_INTERVAL_MILLIS + "ms");
        }
        PingFailureDetector failureDetector = new PingFailureDetector(icmpMaxAttempts);
        taskScheduler.scheduleWithRepetition(() -> {
            failureDetector.retainAttemptsForAliveEndpoints(unmodifiableActiveConnections);
            for (Connection connection : unmodifiableActiveConnections) {
                taskScheduler.execute(() -> ClientICMPManager.ping(logger, failureDetector, connection, icmpTtl, icmpTimeoutMillis));
            }
        }, icmpIntervalMillis, icmpIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private static void echoFailFast(ILogger logger) {
        logger.info("Checking that ICMP failure-detector is permitted. Attempting to create a raw-socket using JNI.");
        if (!ICMPHelper.isRawSocketPermitted()) {
            throw new IllegalStateException("ICMP failure-detector can't be used in this environment. Check Hazelcast Documentation Chapter on the Ping Failure Detector for supported platforms and how to enable this capability for your operating system");
        }
        logger.info("ICMP failure-detector is supported, enabling.");
    }

    private static boolean isReachable(ILogger logger, int icmpTtl, int icmpTimeoutMillis, Address address) {
        try {
            if (address.getInetAddress().isReachable(null, icmpTtl, icmpTimeoutMillis)) {
                logger.fine(String.format("%s is pinged successfully", address));
                return true;
            }
        }
        catch (IOException ignored) {
            EmptyStatement.ignore(ignored);
        }
        return false;
    }

    private static void ping(ILogger logger, PingFailureDetector<Connection> failureDetector, Connection connection, int icmpTtl, int icmpTimeoutMillis) {
        Address address = connection.getRemoteAddress();
        logger.fine(String.format("will ping %s", address));
        if (ClientICMPManager.isReachable(logger, icmpTtl, icmpTimeoutMillis, address)) {
            failureDetector.heartbeat(connection);
            return;
        }
        failureDetector.logAttempt(connection);
        logger.warning(String.format("Could not ping %s", address));
        if (!failureDetector.isAlive(connection)) {
            connection.close("ICMP ping time out", new TargetDisconnectedException("ICMP ping time out to connection " + connection));
        }
    }
}

