/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.config.InvalidConfigurationException;
import java.util.List;

public final class FailoverClientConfigSupport {
    private FailoverClientConfigSupport() {
    }

    public static ClientFailoverConfig resolveClientFailoverConfig() {
        return FailoverClientConfigSupport.resolveClientFailoverConfig(null);
    }

    public static ClientFailoverConfig resolveClientFailoverConfig(ClientFailoverConfig clientFailoverConfig) {
        if (clientFailoverConfig == null) {
            clientFailoverConfig = ClientFailoverConfig.load();
        }
        FailoverClientConfigSupport.checkValidAlternative(clientFailoverConfig.getClientConfigs());
        return clientFailoverConfig;
    }

    public static ClientConfig resolveClientConfig(ClientConfig config) {
        if (config == null) {
            return ClientConfig.load();
        }
        return config;
    }

    private static void checkValidAlternative(List<ClientConfig> alternativeClientConfigs) {
        if (alternativeClientConfigs.isEmpty()) {
            throw new InvalidConfigurationException("ClientFailoverConfig must have at least one client config.");
        }
        ClientConfig mainConfig = alternativeClientConfigs.get(0);
        for (ClientConfig alternativeClientConfig : alternativeClientConfigs.subList(1, alternativeClientConfigs.size())) {
            FailoverClientConfigSupport.checkValidAlternative(mainConfig, alternativeClientConfig);
        }
    }

    private static void throwInvalidConfigurationException(String rootClusterName, String clusterName, String configName) {
        throw new InvalidConfigurationException("Alternative config with cluster name " + clusterName + " has a different config than the initial config with cluster name " + rootClusterName + " for " + configName);
    }

    private static boolean notEqual(Object l, Object r) {
        return l != null ? !l.equals(r) : r != null;
    }

    private static void checkValidAlternative(ClientConfig mainConfig, ClientConfig alternativeConfig) {
        String mainClusterName = mainConfig.getClusterName();
        String alternativeClusterName = alternativeConfig.getClusterName();
        FailoverClientConfigSupport.checkValidAlternativeForNetwork(mainConfig, alternativeConfig);
        if (FailoverClientConfigSupport.notEqual(mainConfig.getProperties(), alternativeConfig.getProperties())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "properties");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getLoadBalancer(), alternativeConfig.getLoadBalancer())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "loadBalancer");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getLoadBalancerClassName(), alternativeConfig.getLoadBalancerClassName())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "loadBalancerClassName");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getListenerConfigs(), alternativeConfig.getListenerConfigs())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "listeners");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getInstanceName(), alternativeConfig.getInstanceName())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "instanceName");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getConfigPatternMatcher(), alternativeConfig.getConfigPatternMatcher())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "configPatternMatcher");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getNearCacheConfigMap(), alternativeConfig.getNearCacheConfigMap())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "nearCache");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getReliableTopicConfigMap(), alternativeConfig.getReliableTopicConfigMap())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "reliableTopic");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getQueryCacheConfigs(), alternativeConfig.getQueryCacheConfigs())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "queryCacheConfigs");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getSerializationConfig(), alternativeConfig.getSerializationConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "serializationConfig");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getNativeMemoryConfig(), alternativeConfig.getNativeMemoryConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "nativeMemory");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getProxyFactoryConfigs(), alternativeConfig.getProxyFactoryConfigs())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "proxyFactory");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getManagedContext(), alternativeConfig.getManagedContext())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "managedContext");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getClassLoader(), alternativeConfig.getClassLoader())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "classLoader");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getConnectionStrategyConfig(), alternativeConfig.getConnectionStrategyConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "connectionStrategy");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getUserCodeDeploymentConfig(), alternativeConfig.getUserCodeDeploymentConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "userCodeDeployment");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getFlakeIdGeneratorConfigMap(), alternativeConfig.getFlakeIdGeneratorConfigMap())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "flakeIdGenerator");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getLabels(), alternativeConfig.getLabels())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "labels");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getUserContext(), alternativeConfig.getUserContext())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "userContext");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getMetricsConfig(), alternativeConfig.getMetricsConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "metricsConfig");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getInstanceTrackingConfig(), alternativeConfig.getInstanceTrackingConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "instanceTrackingConfig");
        }
        if (mainConfig.isBackupAckToClientEnabled() != alternativeConfig.isBackupAckToClientEnabled()) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "isBackupAckToClientEnabled");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getSqlConfig(), alternativeConfig.getSqlConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "sqlConfig");
        }
    }

    private static void checkValidAlternativeForNetwork(ClientConfig mainConfig, ClientConfig alternativeConfig) {
        String mainClusterName = mainConfig.getClusterName();
        String alternativeClusterName = alternativeConfig.getClusterName();
        ClientNetworkConfig mainNetworkConfig = mainConfig.getNetworkConfig();
        ClientNetworkConfig alternativeNetworkConfig = alternativeConfig.getNetworkConfig();
        if (mainNetworkConfig == null && alternativeNetworkConfig == null) {
            return;
        }
        if (mainNetworkConfig == null || alternativeNetworkConfig == null) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "network");
        }
        if (mainNetworkConfig.isSmartRouting() != alternativeNetworkConfig.isSmartRouting()) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "network:smartRouting");
        }
        if (mainNetworkConfig.isRedoOperation() != alternativeNetworkConfig.isRedoOperation()) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "network:redoOperation");
        }
        if (mainNetworkConfig.getConnectionTimeout() != alternativeNetworkConfig.getConnectionTimeout()) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "network:connectionTimeout");
        }
        if (FailoverClientConfigSupport.notEqual(mainNetworkConfig.getSocketOptions(), alternativeNetworkConfig.getSocketOptions())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "network:socketOptions");
        }
        if (FailoverClientConfigSupport.notEqual(mainNetworkConfig.getOutboundPortDefinitions(), alternativeNetworkConfig.getOutboundPortDefinitions())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "network:outboundPortDefinitions");
        }
        if (FailoverClientConfigSupport.notEqual(mainNetworkConfig.getOutboundPorts(), alternativeNetworkConfig.getOutboundPorts())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "network:outboundPorts");
        }
        if (FailoverClientConfigSupport.notEqual(mainNetworkConfig.getClientIcmpPingConfig(), alternativeNetworkConfig.getClientIcmpPingConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alternativeClusterName, "network:clientIcmp");
        }
    }
}

