/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.weave.internal.engine;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.tooling.client.ToolingClientFactory;
import org.mule.tooling.client.ToolingDataWeaveExecutionError;
import org.mule.tooling.client.ToolingDataWeaveExecutionRequest;
import org.mule.tooling.client.ToolingDataWeaveExecutionResponse;
import org.mule.tooling.client.api.DataWeaveExecutionError;
import org.mule.tooling.client.api.DataWeaveExecutionRequest;
import org.mule.tooling.client.api.DataWeaveExecutionResponse;
import org.mule.tooling.client.api.KeyValuePairsResult;
import org.mule.tooling.client.api.ToolingApplication;
import org.mule.tooling.client.api.ToolingClient;
import org.mule.tooling.client.startup.ToolingManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.dfl.dFL.OutputDirective;
import org.mule.tooling.event.model.DataTypeModel;
import org.mule.tooling.event.model.EventModel;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.event.model.TypedValueModel;
import org.mule.tooling.runtime.controller.IMuleInstance;
import org.mule.tooling.runtime.tooling.ToolingProject;
import org.mule.tooling.runtime.tooling.ToolingWorkspace;
import org.mule.tooling.utils.Pair;
import org.mule.tooling.weave.engine.DataFormatManagerHelper;
import org.mule.tooling.weave.engine.IWeaveEngineHelper;
import org.mule.tooling.weave.engine.MimeTypeManager;
import org.mule.tooling.weave.engine.ModuleOption;
import org.mule.tooling.weave.engine.WeaveModule;
import org.mule.tooling.weave.engine.output.IDFLEngineCallback;
import org.mule.tooling.weave.internal.engine.RuntimeWeaveModule;
import org.mule.weave.v2.codegen.CodeGenerator$;
import org.mule.weave.v2.lang.ModuleMimeTypesAPI;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.parser.MappingParser;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.structure.DocumentNode;
import org.mule.weave.v2.parser.ast.structure.DynamicKeyNode;
import org.mule.weave.v2.parser.ast.structure.KeyNode;
import org.mule.weave.v2.parser.ast.structure.KeyValuePairNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.Position;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.CompilationPhase;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingResult;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.sdk.ParsingContextFactory;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResourceFactory;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class WeaveEngineHelper
implements IWeaveEngineHelper {
    private static final ThreadLocal<CacheKey> loadingKey = new ThreadLocal();
    private LoadingCache<CacheKey, Pair<ToolingProject, ToolingApplication>> toolingAppsCache = CacheBuilder.newBuilder().maximumSize(10L).removalListener(removal -> {
        System.out.println("Cleaning tooling app and project for " + ((CacheKey)removal.getKey()).getMuleProject().getName());
        Pair pair = (Pair)removal.getValue();
        try {
            ((ToolingApplication)pair.getRight()).close();
        }
        catch (IOException e) {
            MuleCorePlugin.logError((String)("Error when closing tooling app for project " + ((CacheKey)removal.getKey()).getMuleProject().getName()), (Throwable)e);
        }
        ((ToolingProject)pair.getLeft()).close();
    }).build((CacheLoader)new CacheLoader<CacheKey, Pair<ToolingProject, ToolingApplication>>(){

        public Pair<ToolingProject, ToolingApplication> load(CacheKey key) throws Exception {
            if (!key.isTransitory()) {
                loadingKey.set(key);
            }
            try {
                IMuleProject muleProject = key.getMuleProject();
                ToolingWorkspace toolingWorkspace = ToolingWorkspace.getInstance();
                ToolingProject toolingProject = toolingWorkspace.install(muleProject);
                IMuleInstance instance = ToolingManager.getInstance().getToolingInstance();
                ToolingClient toolingClient = ToolingClientFactory.buildToolingClient((IMuleInstance)instance, (IMuleProject)muleProject);
                if (toolingClient != null) {
                    ToolingApplication toolingApplication = toolingClient.newToolingApplication(toolingProject);
                    Pair pair = new Pair((Object)toolingProject, (Object)toolingApplication);
                    return pair;
                }
                throw new RuntimeException("Unable to create tooling client.");
            }
            finally {
                if (!key.isTransitory()) {
                    loadingKey.remove();
                }
            }
        }
    });

    @Override
    public List<ModuleOption> getReaderOptions(String contentType) {
        return this.getOptions(contentType, WeaveModule::getReaderOptions);
    }

    @Override
    public List<ModuleOption> getWriterOptions(String contentType) {
        return this.getOptions(contentType, WeaveModule::getWriterOptions);
    }

    private List<ModuleOption> getOptions(String contentType, Function<WeaveModule, Map<String, ModuleOption>> f) {
        return this.getModule(contentType).map(m -> new ArrayList(((Map)f.apply((WeaveModule)m)).values())).orElse(Collections.emptyList());
    }

    @Override
    public DataWeaveExecutionResponse validate(DataWeaveExecutionRequest request, IMuleProject muleProject) {
        DataWeaveExecutionResponse response;
        long start = System.currentTimeMillis();
        try {
            response = this.doWithRetry(muleProject, toolingApplication -> toolingApplication.getDataWeaveExecutionService().execute(request));
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Error while validating DataWeave script", (Throwable)e);
            response = ToolingDataWeaveExecutionResponse.builder().withException(e).build();
        }
        System.out.println("Weave validation: " + (System.currentTimeMillis() - start));
        return response;
    }

    private DataWeaveExecutionResponse doWithRetry(IMuleProject muleProject, CheckedFunction<ToolingApplication, DataWeaveExecutionResponse> action) throws Exception {
        DataWeaveExecutionResponse response;
        CacheKey key = this.isAlreadyBeingLoaded(muleProject) ? CacheKey.createTransitory(muleProject) : CacheKey.create(muleProject);
        try {
            try {
                Pair pair = (Pair)this.toolingAppsCache.get((Object)key);
                response = action.apply((ToolingApplication)pair.getRight());
            }
            catch (IllegalStateException illegalStateException) {
                System.out.println("App already dipsosed. Invalidating tooling app.");
                this.toolingAppsCache.invalidate((Object)key);
                Pair pair = (Pair)this.toolingAppsCache.get((Object)key);
                response = action.apply((ToolingApplication)pair.getRight());
                if (key.isTransitory()) {
                    this.toolingAppsCache.invalidate((Object)key);
                }
            }
        }
        finally {
            if (key.isTransitory()) {
                this.toolingAppsCache.invalidate((Object)key);
            }
        }
        return response;
    }

    private boolean isAlreadyBeingLoaded(IMuleProject muleProject) {
        return loadingKey.get() != null && loadingKey.get().isSameProject(muleProject);
    }

    @Override
    public KeyValuePairsResult parseKeyValuePairs(String dflContent) {
        try {
            ParsingContext parsingContext = this.createParsingContext();
            PhaseResult compilationResult = MappingParser.parse((CompilationPhase)MappingParser.canonicalAstPhase(), (WeaveResource)WeaveResourceFactory.fromContent((String)dflContent), (ParsingContext)parsingContext);
            if (compilationResult.hasErrors()) {
                Seq errorMessages = compilationResult.errorMessages();
                return KeyValuePairsResult.fromErrors(this.fromErrorMessages((Seq<Tuple2<WeaveLocation, Message>>)errorMessages));
            }
            ParsingResult result = (ParsingResult)compilationResult.getResult();
            DocumentNode astNode = (DocumentNode)result.astNode();
            Seq keyValuePairNodesSeq = astNode.root().children();
            List keyValuePairNodes = JavaConverters.seqAsJavaList((Seq)keyValuePairNodesSeq);
            LinkedHashMap<String, String> keyValuePairs = new LinkedHashMap<String, String>();
            for (AstNode keyValuePairNode : keyValuePairNodes) {
                if (keyValuePairNode instanceof KeyValuePairNode) {
                    KeyValuePairNode kVPN = (KeyValuePairNode)keyValuePairNode;
                    AstNode k = kVPN.key();
                    AstNode key = null;
                    if (k instanceof KeyNode) {
                        key = ((KeyNode)k).keyName();
                    } else if (k instanceof DynamicKeyNode) {
                        key = ((DynamicKeyNode)k).keyName();
                    }
                    String keyCode = this.emitCode(key);
                    AstNode value = kVPN.value();
                    String valueCode = this.emitCode(value);
                    keyValuePairs.put(keyCode, valueCode);
                    continue;
                }
                return KeyValuePairsResult.fromErrors(Collections.emptyList());
            }
            return KeyValuePairsResult.fromKeyValuePairs(keyValuePairs);
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Error while generating ky value pairs with DataWeave script", (Throwable)e);
            return null;
        }
    }

    private ParsingContext createParsingContext() {
        ParsingContext parsingContext = ParsingContextFactory.createParsingContext((NameIdentifier)NameIdentifier.anonymous());
        parsingContext.addImplicitInput("payload", Option.empty());
        parsingContext.addImplicitInput("attributes", Option.empty());
        parsingContext.addImplicitInput("vars", Option.empty());
        parsingContext.addImplicitInput("error", Option.empty());
        return parsingContext;
    }

    protected String emitCode(AstNode value) {
        return CodeGenerator$.MODULE$.generate(value);
    }

    private List<DataWeaveExecutionError> fromErrorMessages(Seq<Tuple2<WeaveLocation, Message>> errorMessages) {
        return JavaConverters.seqAsJavaList(errorMessages).stream().map(this::fromErrorTuple).collect(Collectors.toList());
    }

    private ToolingDataWeaveExecutionError fromErrorTuple(Tuple2<WeaveLocation, Message> errorTuple) {
        Option maybeLocation = WeaveLocation.unapply((WeaveLocation)((WeaveLocation)errorTuple._1));
        if (maybeLocation.isEmpty()) {
            return null;
        }
        Tuple3 location = (Tuple3)maybeLocation.get();
        Position startPosition = (Position)location._1();
        Position endPosition = (Position)location._2();
        Message message = (Message)errorTuple._2;
        return ToolingDataWeaveExecutionError.builder().withStartIndex(startPosition.index()).withStartLine(startPosition.line()).withEndIndex(endPosition.index()).withMessage(message.message()).build();
    }

    @Override
    public DataWeaveExecutionResponse execute(String script, IMuleProject muleProject) {
        DataWeaveExecutionResponse response;
        ToolingDataWeaveExecutionRequest request = ToolingDataWeaveExecutionRequest.newExecutionRequest().withScript(script).build();
        try {
            response = this.doWithRetry(muleProject, arg_0 -> WeaveEngineHelper.lambda$6((DataWeaveExecutionRequest)request, arg_0));
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Error while executing DataWeave script", (Throwable)e);
            response = ToolingDataWeaveExecutionResponse.builder().withException(e).build();
        }
        return response;
    }

    @Override
    public DataWeaveExecutionResponse executePreview(IMuleProject muleProject, IDFLEngineCallback callback, Optional<OutputDirective> outputDirective, DataWeaveExecutionRequest request) {
        DataWeaveExecutionResponse response;
        try {
            long start = System.currentTimeMillis();
            response = this.doWithRetry(muleProject, toolingApplication -> toolingApplication.getDataWeaveExecutionService().execute(request));
            long end = System.currentTimeMillis();
            String inputPayloadMime = Optional.ofNullable(request.getEventModel()).map(EventModel::getMessage).map(MessageModel::getPayload).map(TypedValueModel::getDataType).map(DataTypeModel::getMediaType).orElse("none");
            String outputMime = outputDirective.map(OutputDirective::getMimeType).orElse("none");
            AnalyticsRecordsFactory.single((String)Events.DW_PREVIEW_EXECUTION, (String[])new String[]{"time", String.valueOf(end - start), "input mime", inputPayloadMime, "output mime", outputMime}).track();
            if (response.isSuccess()) {
                callback.onResult(outputDirective, (String)response.getResult().get());
            } else {
                callback.onException(outputDirective, response);
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError((String)"Error while executing DataWeave script", (Throwable)e);
            response = ToolingDataWeaveExecutionResponse.builder().withException(e).build();
        }
        return response;
    }

    @Override
    public MimeTypeManager getMimeTypeManager() {
        HashSet<String> mimeTypes = new HashSet<String>(ModuleMimeTypesAPI.mimeTypes());
        mimeTypes.addAll(MimeTypeManager.DEFAULT_MIME_TYPES);
        return new MimeTypeManager(mimeTypes.stream().sorted().collect(Collectors.toList()));
    }

    public String toString() {
        return "WeaveEngineHelper (4.0.0)";
    }

    @Override
    public Optional<WeaveModule> getModule(String mimeType) {
        try {
            Optional<DataFormat<?, ?>> maybeWeaveModule = DataFormatManagerHelper.getDataFormatByMimeType(mimeType);
            return maybeWeaveModule.map(RuntimeWeaveModule::from);
        }
        catch (RuntimeException runtimeException) {
            return Optional.empty();
        }
    }

    @Override
    public void invalidateToolingAppFor(IMuleProject muleProject) {
        Job invalidationJob = Job.create((String)("Invalidate tooling app for " + muleProject.getName()), monitor -> this.toolingAppsCache.invalidate((Object)CacheKey.create(muleProject)));
        invalidationJob.schedule();
    }

    private static /* synthetic */ DataWeaveExecutionResponse lambda$6(DataWeaveExecutionRequest dataWeaveExecutionRequest, ToolingApplication toolingApplication) throws Exception {
        return toolingApplication.getDataWeaveExecutionService().execute(dataWeaveExecutionRequest);
    }

    private static class CacheKey {
        private static final int NOT_TRANSITORY_ID = 0;
        private static long nextId = 0L;
        private final long id;
        private final IMuleProject muleProject;

        private static final CacheKey create(IMuleProject muleProject) {
            return new CacheKey(muleProject, 0L);
        }

        private static final CacheKey createTransitory(IMuleProject muleProject) {
            return new CacheKey(muleProject, CacheKey.nextId());
        }

        private static long nextId() {
            if (++nextId == 0L) {
                ++nextId;
            }
            return nextId;
        }

        private CacheKey(IMuleProject muleProject, long id) {
            this.muleProject = muleProject;
            this.id = id;
        }

        private boolean isSameProject(IMuleProject otherProject) {
            return this.muleProject.getProject().equals((Object)otherProject.getProject());
        }

        public IMuleProject getMuleProject() {
            return this.muleProject;
        }

        public boolean isTransitory() {
            return this.id != 0L;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (this.muleProject == null ? 0 : this.muleProject.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.id != other.id) {
                return false;
            }
            return !(this.muleProject == null ? other.muleProject != null : !this.muleProject.equals(other.muleProject));
        }
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, U> {
        public U apply(T var1) throws Exception;
    }
}

