/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.weave.engine;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.mule.tooling.client.api.DataWeaveExecutionRequest;
import org.mule.tooling.client.api.DataWeaveExecutionResponse;
import org.mule.tooling.client.api.KeyValuePairsResult;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.dfl.dFL.OutputDirective;
import org.mule.tooling.weave.engine.IWeaveEngineHelper;
import org.mule.tooling.weave.engine.MimeTypeManager;
import org.mule.tooling.weave.engine.ModuleOption;
import org.mule.tooling.weave.engine.WeaveModule;
import org.mule.tooling.weave.engine.output.IDFLEngineCallback;

public class WeaveEngineHelperManager {
    private static final String EXTENSION_POINT_ID = "org.mule.tooling.weave.engine.helper";
    private static List<IWeaveEngineHelper> engineHelpers;

    public static MimeTypeManager getMimeTypeManager() {
        IWeaveEngineHelper engineHelper = WeaveEngineHelperManager.getDefaultEngineHelper();
        return engineHelper.getMimeTypeManager();
    }

    public static KeyValuePairsResult parseKeyValuePairs(String dflContent) {
        IMuleProject muleProject = MuleCorePlugin.getDesignContext().getMuleProject();
        if (muleProject != null) {
            IWeaveEngineHelper engineHelper = WeaveEngineHelperManager.getDefaultEngineHelper();
            return engineHelper.parseKeyValuePairs(dflContent);
        }
        return null;
    }

    public static Optional<WeaveModule> getModule(String baseType, IMuleProject muleProject) {
        IWeaveEngineHelper engineHelper = WeaveEngineHelperManager.getDefaultEngineHelper();
        return engineHelper.getModule(baseType);
    }

    public static DataWeaveExecutionResponse execute(String dfl, IMuleProject muleProject) {
        IWeaveEngineHelper engineHelper = WeaveEngineHelperManager.getDefaultEngineHelper();
        return engineHelper.execute(dfl, muleProject);
    }

    public static DataWeaveExecutionResponse executePreview(IMuleProject muleProject, IDFLEngineCallback callback, Optional<OutputDirective> outputDirective, DataWeaveExecutionRequest request) {
        IWeaveEngineHelper engineHelper = WeaveEngineHelperManager.getDefaultEngineHelper();
        return engineHelper.executePreview(muleProject, callback, outputDirective, request);
    }

    public static List<ModuleOption> getReaderOptions(String contentType) {
        IWeaveEngineHelper engineHelper = WeaveEngineHelperManager.getDefaultEngineHelper();
        return engineHelper.getReaderOptions(contentType);
    }

    public static List<ModuleOption> getWriterOptions(String contentType) {
        IWeaveEngineHelper engineHelper = WeaveEngineHelperManager.getDefaultEngineHelper();
        return engineHelper.getWriterOptions(contentType);
    }

    private static IWeaveEngineHelper getDefaultEngineHelper() {
        List<IWeaveEngineHelper> engineHelpers = WeaveEngineHelperManager.getEngineHelpers();
        if (engineHelpers.isEmpty()) {
            throw new IllegalStateException("No IWeaveEngineHelper registered");
        }
        return WeaveEngineHelperManager.getEngineHelpers().get(0);
    }

    private static List<IWeaveEngineHelper> getEngineHelpers() {
        if (CollectionUtils.isEmpty(engineHelpers)) {
            engineHelpers = CoreUtils.getExtensionPointObjects((String)EXTENSION_POINT_ID, IWeaveEngineHelper.class);
        }
        return engineHelpers;
    }

    public static void invalidateToolingAppFor(IMuleProject muleProject) {
        IWeaveEngineHelper engineHelper = WeaveEngineHelperManager.getDefaultEngineHelper();
        engineHelper.invalidateToolingAppFor(muleProject);
    }
}

