/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.weave.engine;

import com.google.common.collect.Lists;
import java.util.List;
import org.mule.tooling.weave.engine.ModuleOption;

public class ModuleOptionBuilder {
    private String name;
    private String type;
    private Object defaultValue;
    private String description;
    private List<String> possibleValues = Lists.newArrayList();

    public ModuleOptionBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ModuleOptionBuilder type(String type) {
        this.type = type;
        return this;
    }

    public ModuleOptionBuilder defaultValue(String defaultValue) {
        this.defaultValue = "true".equalsIgnoreCase(defaultValue) ? Boolean.valueOf(true) : ("false".equalsIgnoreCase(defaultValue) ? Boolean.valueOf(false) : defaultValue);
        return this;
    }

    public ModuleOptionBuilder description(String description) {
        this.description = description;
        return this;
    }

    public ModuleOptionBuilder possibleValue(String possibleValue) {
        this.possibleValues.add(possibleValue);
        return this;
    }

    public ModuleOptionBuilder possibleValues(List<String> possibleValues) {
        this.possibleValues.addAll(possibleValues);
        return this;
    }

    public ModuleOption build() {
        return new ModuleOption(this.name, this.type, this.defaultValue, this.description, this.possibleValues);
    }
}

