/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.weave.engine;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.mule.tooling.weave.engine.ModuleOptionBuilder;

public class ModuleOption {
    public static final String NUMBER_TYPE = "Number";
    public static final String BOOLEAN_TYPE = "Boolean";
    public static final String STRING_TYPE = "String";
    private final String name;
    private final String type;
    private final Object defaultValue;
    private final String description;
    private final List<String> possibleValues;

    public ModuleOption(String name, String type, Object defaultValue, String description, List<String> possibleValues) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
        this.description = description;
        this.possibleValues = possibleValues;
    }

    public static ModuleOption from(Map<String, String> map) {
        ModuleOptionBuilder builder = new ModuleOptionBuilder();
        builder.name(map.get("name"));
        builder.type(map.get("type"));
        builder.defaultValue(map.get("defaultValue"));
        builder.description(map.get("description"));
        String possibleVals = map.get("possibleValues");
        if (!possibleVals.isEmpty()) {
            ArrayList vals = Lists.newArrayList((Object[])possibleVals.split(","));
            builder.possibleValues(vals);
        } else {
            builder.possibleValues(new ArrayList<String>());
        }
        return builder.build();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getPossibleValues() {
        return this.possibleValues;
    }

    private String quote(String str) {
        return "\"" + str + "\"";
    }

    public String defaultAsLiteral() {
        return this.asLiteral(this.getDefaultValue());
    }

    private String asLiteral(Object value) {
        String str = String.valueOf(value);
        if (this.isString()) {
            return this.quote(StringEscapeUtils.escapeJava((String)str));
        }
        return str;
    }

    public List<String> getPossibleValuesAsLiterals() {
        return this.possibleValues.stream().map(this::asLiteral).collect(Collectors.toList());
    }

    public boolean isString() {
        return STRING_TYPE.equals(this.getType());
    }

    public boolean isBoolean() {
        return BOOLEAN_TYPE.equals(this.getType());
    }

    public boolean isNumber() {
        return NUMBER_TYPE.equals(this.getType());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleOption other = (ModuleOption)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

