/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.weave.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.DataFormatManager;
import org.mule.weave.v2.parser.module.MimeType;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class DataFormatManagerHelper {
    public static Optional<DataFormat<?, ?>> getDataFormatByMimeType(String mimeType) {
        if (mimeType == null || mimeType.trim().isEmpty()) {
            return Optional.empty();
        }
        if (mimeType.contains("/")) {
            return DataFormatManagerHelper.getDataFormatByContentType(mimeType);
        }
        return DataFormatManagerHelper.getDataFormatByName(mimeType);
    }

    public static Optional<DataFormat<?, ?>> getDataFormatByExtension(String extension) {
        return Optional.ofNullable((DataFormat)DataFormatManager.byExtension((String)extension, (EvaluationContext)DataFormatManagerHelper.createEvaluationContext()).getOrElse(() -> null));
    }

    public static Optional<DataFormat<?, ?>> getDataFormatByContentType(String contentType) {
        return Optional.ofNullable((DataFormat)DataFormatManager.byContentType((String)contentType, (EvaluationContext)DataFormatManagerHelper.createEvaluationContext()).getOrElse(() -> null));
    }

    public static Optional<DataFormat<?, ?>> getDataFormatByName(String name) {
        return Optional.ofNullable((DataFormat)DataFormatManager.byName((String)name, (EvaluationContext)DataFormatManagerHelper.createEvaluationContext()).getOrElse(() -> null));
    }

    private static EvaluationContext createEvaluationContext() {
        return EvaluationContext.apply();
    }

    public static List<String> getMimeTypes() {
        ArrayList<String> result = new ArrayList<String>();
        Seq modules = DataFormatManager.modules((EvaluationContext)DataFormatManagerHelper.createEvaluationContext());
        JavaConverters.asJavaCollection((Iterable)modules).forEach(m -> result.add(m.defaultMimeType().toString()));
        return result;
    }

    public static List<MetadataFormat> getMetadataFormats() {
        ArrayList<MetadataFormat> result = new ArrayList<MetadataFormat>();
        Seq modules = DataFormatManager.modules((EvaluationContext)DataFormatManagerHelper.createEvaluationContext());
        JavaConverters.asJavaCollection((Iterable)modules).forEach(m -> result.add(DataFormatManagerHelper.asMetadataFormat(m.defaultMimeType())));
        return result;
    }

    public static MetadataFormat asMetadataFormat(MimeType defaultMimeType) {
        String id = defaultMimeType.subtype().toLowerCase();
        String label = StringUtils.capitalize((String)id);
        MetadataFormat metadataFormat = new MetadataFormat(label, id, new String[]{defaultMimeType.toString()});
        return metadataFormat;
    }
}

