/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.monitoring.publisher;

import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.services.OnOffSwitch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="mule.agent.zabbix.jmx.internal.handler")
@Singleton
public class ZabbixMonitorPublisher
extends BufferedHandler<ArrayList<Metric>> {
    private static final Logger LOGGER = LogManager.getLogger(ZabbixMonitorPublisher.class);
    private static final String MESSAGE_START = "{\"request\":\"sender data\",\"data\":[{\"host\":\"";
    private static final String MESSAGE_MIDDLE_LEFT = "\",\"key\":\"";
    private static final String MESSAGE_MIDDLE_RIGHT = "\",\"value\":\"";
    private static final String MESSAGE_END = "\"}]}\n";
    public static final int SHIFT_TWO = 8;
    public static final int SHIFT_FOUR = 16;
    public static final int SHIFT_SIX = 24;
    public static final int BITMASK = 255;
    public static final int SHIFT_TWO_BITMASK = 255;
    public static final int SHIFT_FOUR_BITMASK = 255;
    public static final int SHIFT_SIX_BITMASK = 255;
    @Configurable(value="com.mulesoft.agent")
    String host;
    @Configurable(value="0.0.0.0")
    String zabbixServer;
    @Configurable(value="10051")
    int zabbixPort;

    @Inject
    public ZabbixMonitorPublisher() {
    }

    public ZabbixMonitorPublisher(OnOffSwitch enabledSwitch) {
        this.enabledSwitch = enabledSwitch;
    }

    public boolean canHandle(@NotNull ArrayList<Metric> metrics) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flush(@NotNull Collection<ArrayList<Metric>> listOfMetrics) {
        Socket zabbixConnection = null;
        OutputStream out = null;
        BufferedReader in = null;
        try {
            for (List list : listOfMetrics) {
                for (Metric metric : list) {
                    zabbixConnection = new Socket(this.zabbixServer, this.zabbixPort);
                    StringBuilder message = new StringBuilder();
                    message.append(MESSAGE_START);
                    message.append(this.host);
                    message.append(MESSAGE_MIDDLE_LEFT);
                    message.append(metric.getName().replaceAll("\\s", "").replace(":", ""));
                    message.append(MESSAGE_MIDDLE_RIGHT);
                    message.append(metric.getValue());
                    message.append(MESSAGE_END);
                    String s = message.toString();
                    byte[] chars = s.getBytes();
                    int length = chars.length;
                    out = zabbixConnection.getOutputStream();
                    out.write(new byte[]{90, 66, 88, 68, 1, (byte)(length & 0xFF), (byte)(length >> 8 & 0xFF), (byte)(length >> 16 & 0xFF), (byte)(length >> 24 & 0xFF), 0, 0, 0, 0});
                    out.write(chars);
                    out.flush();
                    in = new BufferedReader(new InputStreamReader(zabbixConnection.getInputStream()));
                    LOGGER.debug("Message sent to Zabbix: " + message.toString());
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to establish connection to Zabbix", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
                if (zabbixConnection != null) {
                    zabbixConnection.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }
}

