/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.bootstrap;

import com.mulesoft.mule.bootstrap.WrapperlessArgumentsResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class CommandLineParser {
    public static final String HELP_OPTION = "help";
    private final List<Option> validOptions = new ArrayList<Option>();
    private final List<String> requiredPositionalArguments = new ArrayList<String>();
    private final Map<String, String> optionValues = new HashMap<String, String>();
    private final List<String> requiredPositionalArgumentValues = new ArrayList<String>();
    private String[] additionalArguments;

    public CommandLineParser() {
        this.validOptions.add(new Option(HELP_OPTION, "Show this help message and exit", false));
    }

    public CommandLineParser withOption(String name, String description) {
        this.validOptions.add(new Option(name, description, true));
        return this;
    }

    public CommandLineParser withRequiredPositionalArgument(String name) {
        this.requiredPositionalArguments.add(name);
        return this;
    }

    public void parse(String ... args) {
        this.optionValues.clear();
        this.requiredPositionalArgumentValues.clear();
        int firstNonOptionPos = 0;
        int i = 0;
        while (i < args.length && args[i].startsWith("-")) {
            this.parseOption(args[i]);
            firstNonOptionPos = ++i;
        }
        boolean validateRequiredArguments = !this.getBooleanOption(HELP_OPTION);
        for (int i2 = 0; i2 < this.requiredPositionalArguments.size(); ++i2) {
            if (firstNonOptionPos + i2 >= args.length) {
                if (!validateRequiredArguments) break;
                throw new IllegalArgumentException(String.format("Missing required argument %s", this.requiredPositionalArguments.get(i2)));
            }
            this.requiredPositionalArgumentValues.add(args[firstNonOptionPos + i2]);
        }
        this.additionalArguments = Arrays.copyOfRange(args, firstNonOptionPos + this.requiredPositionalArgumentValues.size(), args.length);
    }

    public Optional<String> getOptionValue(String option) {
        return Optional.ofNullable(this.optionValues.get(option));
    }

    public boolean getBooleanOption(String option) {
        return Optional.ofNullable(this.optionValues.get(option)).map(Boolean::parseBoolean).orElse(false);
    }

    public String getRequiredPositionalArgument(int i) {
        return this.requiredPositionalArgumentValues.get(i);
    }

    public String[] getAdditionalArguments() {
        return this.additionalArguments;
    }

    public void printUsage() {
        String requiredPositionalArgumentsString = this.requiredPositionalArguments.stream().map(s -> String.format("<%s> ", s)).collect(Collectors.joining());
        System.out.println("Usage:");
        System.out.printf("%s [OPTIONS] %s[additionalArgs...]\n", WrapperlessArgumentsResolver.class.getSimpleName(), requiredPositionalArgumentsString);
        System.out.println("Where options include:");
        for (Option option : this.validOptions) {
            if (option.isValueRequired()) {
                System.out.printf("\t--%s=<value>\t%s\n", option.getName(), option.getDescription());
                continue;
            }
            System.out.printf("\t--%s\t%s\n", option.getName(), option.getDescription());
        }
    }

    private void parseOption(String optionArg) {
        for (Option validOption : this.validOptions) {
            if (!validOption.matches(optionArg)) continue;
            String[] split = optionArg.split("=", 2);
            if (validOption.isValueRequired() && split.length != 2) {
                throw new IllegalArgumentException(String.format("Option %s requires a value", validOption.getName()));
            }
            this.optionValues.put(validOption.getName(), split.length != 2 ? "true" : split[1]);
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid option: %s", optionArg));
    }

    private static class Option {
        private final String name;
        private final String description;
        private final boolean requiresValue;

        public Option(String name, String description, boolean requiresValue) {
            this.name = name;
            this.description = description;
            this.requiresValue = requiresValue;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isValueRequired() {
            return this.requiresValue;
        }

        public boolean matches(String optionArg) {
            return optionArg.equals("--" + this.name) || this.requiresValue && optionArg.startsWith("--" + this.name + "=");
        }
    }
}

