/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.mule.xml.schemas;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;
import org.apache.xmlbeans.impl.schema.SchemaTypeLoaderImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeSystemCompiler;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.mule.metadata.xml.api.schema.SchemaFetcher;
import org.mule.metadata.xml.api.utils.SchemaHelper;
import org.mule.tooling.mule.xml.schemas.MuleSchemaTypeSystem;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlSchemaUtils {
    private static final String XML_DEFAULT_CHAR_SET = "UTF-8";
    private static final String FORMAT_PRETTY_PRINT_PARAMETER = "format-pretty-print";
    private static final String XML_DECLARATION_PARAMETER = "xml-declaration";

    public static MuleSchemaTypeSystem getSchemaTypeSystem(URL[] schemas) throws Exception {
        XmlOptions options = new XmlOptions();
        options.setCompileNoUpaRule();
        options.setCompileNoValidation();
        options.setCompileDownloadUrls();
        XmlObject[] schemaRepresentation = new XmlObject[schemas.length];
        SchemaTypeLoader contextTypeLoader = SchemaTypeLoaderImpl.build((SchemaTypeLoader[])new SchemaTypeLoader[]{BuiltinSchemaTypeSystem.get()}, null, (ClassLoader)XmlTypeLoader.class.getClassLoader());
        int i = 0;
        URL[] uRLArray = schemas;
        int n = schemas.length;
        int n2 = 0;
        while (n2 < n) {
            XmlObject schemaObject;
            URL schemaURL = uRLArray[n2];
            schemaRepresentation[i] = schemaObject = contextTypeLoader.parse(schemaURL, null, null);
            ++i;
            ++n2;
        }
        return new MuleSchemaTypeSystem((SchemaTypeSystem)SchemaTypeSystemCompiler.compile(null, null, (XmlObject[])schemaRepresentation, null, (SchemaTypeLoader)contextTypeLoader, null, (XmlOptions)options));
    }

    public static MuleSchemaTypeSystem getSchemaTypeSystem(List<String> schemas) throws Exception {
        XmlOptions options = new XmlOptions();
        options.setCompileNoUpaRule();
        options.setCompileNoValidation();
        options.setCompileDownloadUrls();
        XmlObject[] schemaRepresentation = new XmlObject[schemas.size()];
        SchemaTypeLoader contextTypeLoader = SchemaTypeLoaderImpl.build((SchemaTypeLoader[])new SchemaTypeLoader[]{BuiltinSchemaTypeSystem.get()}, null, (ClassLoader)XmlTypeLoader.class.getClassLoader());
        int i = 0;
        for (String schemaStream : schemas) {
            XmlObject schemaObject;
            schemaRepresentation[i] = schemaObject = contextTypeLoader.parse(schemaStream, null, null);
            ++i;
        }
        return new MuleSchemaTypeSystem((SchemaTypeSystem)SchemaTypeSystemCompiler.compile(null, null, (XmlObject[])schemaRepresentation, null, (SchemaTypeLoader)contextTypeLoader, null, (XmlOptions)options));
    }

    public static Set<File> getDependencies(File file) {
        HashSet<File> dependencies = new HashSet<File>();
        List dependenciesFromSchema = SchemaHelper.getDependencies((File)file);
        for (SchemaFetcher.XsdDependency xsdDependency : dependenciesFromSchema) {
            URL dependencyAsURL = xsdDependency.getDependency();
            if (!"file".equals(dependencyAsURL.getProtocol())) continue;
            try {
                dependencies.add(new File(xsdDependency.getDependency().toURI()));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return dependencies;
    }

    public static String prettyPrint(String content) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(content)));
        Boolean keepDeclaration = content.startsWith("<?xml");
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer serializer = domImplementationLS.createLSSerializer();
            DOMConfiguration domConfiguration = serializer.getDomConfig();
            if (domConfiguration.canSetParameter(FORMAT_PRETTY_PRINT_PARAMETER, Boolean.TRUE)) {
                serializer.getDomConfig().setParameter(FORMAT_PRETTY_PRINT_PARAMETER, Boolean.TRUE);
                serializer.getDomConfig().setParameter(XML_DECLARATION_PARAMETER, keepDeclaration);
                serializer.setNewLine(System.getProperty("line.separator"));
                LSOutput lsOutput = domImplementationLS.createLSOutput();
                String encoding = document.getXmlEncoding();
                lsOutput.setEncoding(StringUtils.isNotBlank((CharSequence)encoding) ? encoding : XML_DEFAULT_CHAR_SET);
                StringWriter stringWriter = new StringWriter();
                lsOutput.setCharacterStream(stringWriter);
                serializer.write(document, lsOutput);
                return stringWriter.toString();
            }
            throw new RuntimeException("DOMConfiguration 'format-pretty-print' parameter isn't settable.");
        }
        catch (Exception e) {
            throw new RuntimeException("Error while serializing document", e);
        }
    }
}

