/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.mule.log;

import org.mule.tooling.mule.log.Slf4jLoggerAdapter;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;

public class MuleLogger
extends Slf4jLoggerAdapter {
    private Level currentLevel;

    public MuleLogger(Level currentLevel) {
        this.currentLevel = currentLevel;
    }

    public String getName() {
        return "Studio custom logger";
    }

    public boolean isInfoEnabled() {
        return this.isLevelEnabled(Level.INFO);
    }

    public boolean isDebugEnabled() {
        return this.isLevelEnabled(Level.DEBUG);
    }

    public boolean isErrorEnabled() {
        return this.isLevelEnabled(Level.ERROR);
    }

    public boolean isWarnEnabled() {
        return this.isLevelEnabled(Level.WARN);
    }

    public boolean isTraceEnabled() {
        return this.isLevelEnabled(Level.TRACE);
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.infoLog(message);
        }
    }

    public void info(String message, Object arg1) {
        if (this.isInfoEnabled()) {
            this.infoLog(MessageFormatter.format((String)message, (Object)arg1).getMessage());
        }
    }

    public void info(String message, Object ... arg1) {
        if (this.isInfoEnabled()) {
            this.infoLog(MessageFormatter.arrayFormat((String)message, (Object[])arg1).getMessage());
        }
    }

    public void info(String message, Throwable arg1) {
        if (this.isInfoEnabled()) {
            this.infoLog(MessageFormatter.format((String)message, (Object)this.print(arg1)).getMessage());
        }
    }

    public void info(String message, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.infoLog(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
        }
    }

    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.warnLog(message);
        }
    }

    public void warn(String message, Object arg1) {
        if (this.isWarnEnabled()) {
            this.warnLog(MessageFormatter.format((String)message, (Object)arg1).getMessage());
        }
    }

    public void warn(String message, Object ... arg1) {
        if (this.isWarnEnabled()) {
            this.warnLog(MessageFormatter.arrayFormat((String)message, (Object[])arg1).getMessage());
        }
    }

    public void warn(String message, Throwable arg1) {
        if (this.isWarnEnabled()) {
            this.warnLog(MessageFormatter.format((String)message, (Object)this.print(arg1)).getMessage());
        }
    }

    public void warn(String message, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.warnLog(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
        }
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.debugLog(message);
        }
    }

    public void debug(String message, Object arg1) {
        if (this.isDebugEnabled()) {
            this.debugLog(MessageFormatter.format((String)message, (Object)arg1).getMessage());
        }
    }

    public void debug(String message, Object ... arg1) {
        if (this.isDebugEnabled()) {
            this.debugLog(MessageFormatter.arrayFormat((String)message, (Object[])arg1).getMessage());
        }
    }

    public void debug(String message, Throwable arg1) {
        if (this.isDebugEnabled()) {
            this.debugLog(MessageFormatter.format((String)message, (Object)this.print(arg1)).getMessage());
        }
    }

    public void debug(String message, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.debugLog(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
        }
    }

    public void error(String message) {
        if (this.isErrorEnabled()) {
            this.errorLog(message);
        }
    }

    public void error(String message, Object arg1) {
        if (this.isErrorEnabled()) {
            this.errorLog(MessageFormatter.format((String)message, (Object)arg1).getMessage());
        }
    }

    public void error(String message, Object ... arg1) {
        if (this.isErrorEnabled()) {
            this.errorLog(MessageFormatter.arrayFormat((String)message, (Object[])arg1).getMessage());
        }
    }

    public void error(String message, Throwable arg1) {
        if (this.isErrorEnabled()) {
            this.errorLog(MessageFormatter.format((String)message, (Object)this.print(arg1)).getMessage());
        }
    }

    public void error(String message, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.errorLog(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
        }
    }

    public void trace(String message) {
        if (this.isTraceEnabled()) {
            this.defaultLog(message);
        }
    }

    public void trace(String message, Object arg1) {
        if (this.isTraceEnabled()) {
            this.defaultLog(MessageFormatter.format((String)message, (Object)arg1).getMessage());
        }
    }

    public void trace(String message, Object ... arg1) {
        if (this.isTraceEnabled()) {
            this.defaultLog(MessageFormatter.arrayFormat((String)message, (Object[])arg1).getMessage());
        }
    }

    public void trace(String message, Throwable arg1) {
        if (this.isTraceEnabled()) {
            this.defaultLog(MessageFormatter.format((String)message, (Object)this.print(arg1)).getMessage());
        }
    }

    public void trace(String message, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.defaultLog(MessageFormatter.format((String)message, (Object)arg1, (Object)arg2).getMessage());
        }
    }

    private void infoLog(String message) {
        this.defaultLog("[INFO] ", message);
    }

    private void debugLog(String message) {
        this.defaultLog("[DEBUG] ", message);
    }

    private void warnLog(String message) {
        this.defaultLog("[WARNING] ", message);
    }

    private void errorLog(String message) {
        this.defaultLog("[ERROR] ", message);
    }

    private void defaultLog(String message) {
        this.defaultLog("", message);
    }

    private void defaultLog(String prefix, String message) {
        System.out.println(prefix + message);
        System.out.flush();
    }

    private boolean isLevelEnabled(Level level) {
        return level.toInt() >= this.currentLevel.toInt();
    }
}

