/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.streaming;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.io.InputStream;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.FeedableHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.service.http.netty.impl.server.ChannelPromises;
import org.mule.service.http.netty.impl.server.HttpWriter;
import org.mule.service.http.netty.impl.streaming.StatusCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingEntitySender {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingEntitySender.class);
    private static final String SELECTOR_TIMEOUT = "mule.timeoutToUseSelectorWhileStreamingResponseMillis";
    private final long SELECTOR_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(Long.valueOf(System.getProperty("mule.timeoutToUseSelectorWhileStreamingResponseMillis", "50")));
    public static final int ENTITY_STREAMING_BUFFER_SIZE = 8192;
    private static final int END_OF_STREAM = -1;
    private final ChannelHandlerContext ctx;
    private final int bufferSize;
    private final Runnable beforeWrite;
    private final StatusCallback statusCallback;
    private final InputStream contentAsInputStream;
    private final OptionalLong entityLength;
    private final HttpWriter writer;
    private final AtomicLong bytesAlreadySent;
    private final long initialNanos;
    private final AtomicBoolean isAlreadyScheduledToIO;
    private final Executor ioExecutor;
    private final HttpEntity entity;

    public StreamingEntitySender(HttpEntity entity, ChannelHandlerContext ctx, Runnable beforeWrite, StatusCallback statusCallback, Executor ioExecutor, HttpWriter writer) {
        this.ctx = ctx;
        this.contentAsInputStream = entity.getContent();
        this.entityLength = entity.getBytesLength();
        this.writer = writer;
        this.bufferSize = this.calculateBufferSize();
        this.beforeWrite = beforeWrite;
        this.statusCallback = statusCallback;
        this.bytesAlreadySent = new AtomicLong(0L);
        this.initialNanos = System.nanoTime();
        this.isAlreadyScheduledToIO = new AtomicBoolean(false);
        this.ioExecutor = ioExecutor;
        this.entity = entity;
    }

    public void sendNextChunk() throws IOException {
        byte[] buf;
        int bytesActuallyRead;
        if (this.bufferSize == 0) {
            this.sendTrailingContentAndFinish(this.contentAsInputStream);
            return;
        }
        if (this.shouldScheduleNextChunkToIO()) {
            boolean couldScheduleToIO = this.tryScheduleNextChunkHandlingToIO();
            if (couldScheduleToIO) {
                return;
            }
            LOGGER.debug("Tried to schedule next chunk handling to IO, but the task was rejected. It will be executed in the current thread.");
        }
        if (-1 == (bytesActuallyRead = StreamingEntitySender.readChunk(this.contentAsInputStream, buf = new byte[this.bufferSize]))) {
            this.sendTrailingContentAndFinish(this.contentAsInputStream);
        } else {
            ByteBuf content = this.createBuffer(bytesActuallyRead);
            content.writeBytes(buf, 0, bytesActuallyRead);
            if (this.weKnowItIsTheLastChunk(bytesActuallyRead, this.bytesAlreadySent.get())) {
                this.sendBufferWithPromise(content, true, ChannelPromises.finishStreamingPromise(this.ctx, this.contentAsInputStream, this.statusCallback));
            } else {
                this.sendBufferWithPromise(content, false, ChannelPromises.sendNextChunkPromise(this.ctx, this, this.statusCallback));
            }
            this.bytesAlreadySent.addAndGet(bytesActuallyRead);
        }
    }

    private boolean shouldScheduleNextChunkToIO() throws IOException {
        long currentTime = System.nanoTime() - this.initialNanos;
        boolean mayBlock = this.entity instanceof FeedableHttpEntity && this.contentAsInputStream.available() == 0;
        return (mayBlock || currentTime >= this.SELECTOR_TIMEOUT_NANOS) && !this.isAlreadyScheduledToIO.get();
    }

    private boolean tryScheduleNextChunkHandlingToIO() {
        try {
            this.ioExecutor.execute(() -> {
                try {
                    LOGGER.debug("Scheduling next chunk handling to IO");
                    this.sendNextChunk();
                }
                catch (IOException e) {
                    this.statusCallback.onFailure(e);
                }
            });
            this.isAlreadyScheduledToIO.set(true);
            return true;
        }
        catch (RejectedExecutionException ree) {
            return false;
        }
    }

    private boolean weKnowItIsTheLastChunk(int bytesToSend, long bytesAlreadySent) {
        if (!this.entityLength.isPresent()) {
            return false;
        }
        return bytesAlreadySent + (long)bytesToSend >= this.entityLength.getAsLong();
    }

    private int calculateBufferSize() {
        return Math.min(Math.toIntExact(this.entityLength.orElse(8192L)), 8192);
    }

    private ByteBuf createBuffer(int size) {
        return this.ctx.alloc().buffer(size, size);
    }

    private void sendTrailingContentAndFinish(InputStream contentAsInputStream) {
        this.beforeWrite.run();
        this.entity.onComplete((trailers, throwable) -> {
            if (trailers.isEmpty()) {
                this.writer.writeContent(Unpooled.EMPTY_BUFFER, true, ChannelPromises.finishStreamingPromise(this.ctx, contentAsInputStream, this.statusCallback));
            } else {
                this.writer.writeTrailers((MultiMap<String, String>)trailers, ChannelPromises.finishStreamingPromise(this.ctx, contentAsInputStream, this.statusCallback));
            }
        });
    }

    private void sendBufferWithPromise(ByteBuf content, boolean isLast, ChannelPromise promise) {
        this.beforeWrite.run();
        this.writer.writeContent(content, isLast, promise);
    }

    private static int readChunk(InputStream contentAsInputStream, byte[] buf) throws IOException {
        try {
            LOGGER.debug("Trying to read a chunk from stream");
            return contentAsInputStream.read(buf);
        }
        catch (IllegalStateException exception) {
            if ("Buffer is closed".equals(exception.getMessage())) {
                return -1;
            }
            throw exception;
        }
    }
}

