/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.util.AsciiString;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import org.mule.service.http.netty.impl.server.MultiplexerChannelInitializer;
import org.mule.service.http.netty.impl.server.RejectFailedUpgradeHandler;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;

class UpgradeToHttp2CleartextCodecFactory
implements HttpServerUpgradeHandler.UpgradeCodecFactory {
    private final HttpListenerRegistry httpListenerRegistry;
    private final Executor ioExecutor;

    public UpgradeToHttp2CleartextCodecFactory(HttpListenerRegistry httpListenerRegistry, Executor ioExecutor) {
        this.httpListenerRegistry = httpListenerRegistry;
        this.ioExecutor = ioExecutor;
    }

    public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
        if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
            return new UpdateCodecWithErrorResponse((HttpServerUpgradeHandler.UpgradeCodec)new Http2ServerUpgradeCodec(Http2FrameCodecBuilder.forServer().build(), new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new MultiplexerChannelInitializer(this.httpListenerRegistry, null, this.ioExecutor))}));
        }
        return null;
    }

    private static final class UpdateCodecWithErrorResponse
    implements HttpServerUpgradeHandler.UpgradeCodec {
        public static final String MISSING_CONNECTION_HEADER_VALUE = "HTTP Upgrade request to HTTP2 failed because Connection header doesn't contain required values";
        public static final String UPGRADE_FAILED = "HTTP Upgrade request to HTTP2 failed";
        private final HttpServerUpgradeHandler.UpgradeCodec delegate;

        private UpdateCodecWithErrorResponse(HttpServerUpgradeHandler.UpgradeCodec delegate) {
            this.delegate = delegate;
        }

        public Collection<CharSequence> requiredUpgradeHeaders() {
            return List.of();
        }

        public boolean prepareUpgradeResponse(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest, HttpHeaders upgradeHeaders) {
            if (!this.containsRequiredUpgradeHeaders(upgradeRequest)) {
                ctx.fireUserEventTriggered((Object)new RejectFailedUpgradeHandler.FailedHttpUpgrade((HttpRequest)upgradeRequest, MISSING_CONNECTION_HEADER_VALUE));
                return false;
            }
            if (!this.delegate.prepareUpgradeResponse(ctx, upgradeRequest, upgradeHeaders)) {
                ctx.fireUserEventTriggered((Object)new RejectFailedUpgradeHandler.FailedHttpUpgrade((HttpRequest)upgradeRequest, UPGRADE_FAILED));
                return false;
            }
            return true;
        }

        public void upgradeTo(ChannelHandlerContext ctx, FullHttpRequest upgradeRequest) {
            this.delegate.upgradeTo(ctx, upgradeRequest);
        }

        private static Collection<CharSequence> getConnectionHeaders(FullHttpRequest upgradeRequest) {
            List connectionHeaderValues = upgradeRequest.headers().getAll((CharSequence)HttpHeaderNames.CONNECTION);
            HashSet<CharSequence> connectionHeaders = new HashSet<CharSequence>(connectionHeaderValues.size() * 2);
            for (String connectionHeaderValue : connectionHeaderValues) {
                for (String splitValue : connectionHeaderValue.split(",")) {
                    connectionHeaders.add(splitValue.trim());
                }
            }
            return connectionHeaders;
        }

        private boolean containsRequiredUpgradeHeaders(FullHttpRequest upgradeRequest) {
            Collection<CharSequence> connectionHeaders = UpdateCodecWithErrorResponse.getConnectionHeaders(upgradeRequest);
            Collection requiredConnectionHeaders = this.delegate.requiredUpgradeHeaders();
            return AsciiString.containsAllContentEqualsIgnoreCase(connectionHeaders, (Collection)requiredConnectionHeaders);
        }
    }
}

