/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.DefaultHttp2ResetFrame;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.RequestHandler;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.service.http.netty.impl.server.NettyHttp2RequestAdapter;
import org.mule.service.http.netty.impl.server.NettyHttp2RequestReadyCallback;
import org.mule.service.http.netty.impl.server.NettyHttpRequestContext;
import org.mule.service.http.netty.impl.server.util.DefaultServerAddress;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyToMuleHttp2RequestHandlerAdapter
extends SimpleChannelInboundHandler<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyToMuleHttp2RequestHandlerAdapter.class);
    private static final boolean STRICT_HTTP2_VALIDATION_ENABLED = Boolean.parseBoolean(System.getProperty("mule.http2.strictHeaderValidation.enable", "true"));
    private static final boolean[] VALID_TOKEN_CHARS = NettyToMuleHttp2RequestHandlerAdapter.createValidTokenChars();
    private final HttpListenerRegistry httpListenerRegistry;
    private final SslHandler sslHandler;
    private final Executor ioExecutor;
    private NettyHttp2RequestAdapter request;

    private static boolean[] createValidTokenChars() {
        int c;
        boolean[] chars = new boolean[128];
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            chars[c] = true;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            chars[c] = true;
        }
        for (char c2 : "!#$%&'*+-.^_`|~".toCharArray()) {
            chars[c2] = true;
        }
        return chars;
    }

    public NettyToMuleHttp2RequestHandlerAdapter(HttpListenerRegistry httpListenerRegistry, SslHandler sslHandler, Executor ioExecutor) {
        this.httpListenerRegistry = httpListenerRegistry;
        this.sslHandler = sslHandler;
        this.ioExecutor = ioExecutor;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Http2DataFrame) {
            Http2DataFrame dataFrame = (Http2DataFrame)msg;
            this.onDataFrameRead(dataFrame);
        } else if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
            if (this.request == null) {
                this.onHeadersFrameRead(ctx, headersFrame);
            } else {
                this.onTrailersFrameRead(ctx, headersFrame);
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }

    private void onHeadersFrameRead(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) throws IOException {
        if (STRICT_HTTP2_VALIDATION_ENABLED && !NettyToMuleHttp2RequestHandlerAdapter.hasValidHttp2HeaderNames(headersFrame.headers(), true)) {
            LOGGER.debug("Rejecting HTTP/2 request with invalid header name");
            ctx.writeAndFlush((Object)new DefaultHttp2ResetFrame(Http2Error.PROTOCOL_ERROR).stream(headersFrame.stream()));
            return;
        }
        InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().localAddress();
        DefaultServerAddress serverAddress = new DefaultServerAddress(socketAddress.getAddress(), socketAddress.getPort());
        this.request = new NettyHttp2RequestAdapter(headersFrame);
        if (headersFrame.isEndStream()) {
            this.request.finishEntityAndSetTrailers();
        }
        RequestHandler requestHandler = this.httpListenerRegistry.getRequestHandler(serverAddress, this.request);
        NettyHttpRequestContext requestContext = new NettyHttpRequestContext(this.request, ctx, this.sslHandler);
        NettyHttp2RequestReadyCallback responseReadyCallback = new NettyHttp2RequestReadyCallback(ctx, headersFrame.stream(), this.request, this.ioExecutor);
        try {
            this.ioExecutor.execute(() -> requestHandler.handleRequest((HttpRequestContext)requestContext, (HttpResponseReadyCallback)responseReadyCallback));
        }
        catch (RejectedExecutionException ree) {
            LOGGER.debug("IO Executor is busy, processing request synchronously");
            requestHandler.handleRequest((HttpRequestContext)requestContext, (HttpResponseReadyCallback)responseReadyCallback);
        }
    }

    private void onTrailersFrameRead(ChannelHandlerContext ctx, Http2HeadersFrame trailersFrame) throws IOException {
        if (STRICT_HTTP2_VALIDATION_ENABLED && !NettyToMuleHttp2RequestHandlerAdapter.hasValidHttp2HeaderNames(trailersFrame.headers(), false)) {
            LOGGER.debug("Rejecting HTTP/2 request with invalid trailer name");
            ctx.writeAndFlush((Object)new DefaultHttp2ResetFrame(Http2Error.PROTOCOL_ERROR).stream(trailersFrame.stream()));
            return;
        }
        for (Map.Entry entry : trailersFrame.headers()) {
            String headerName = ((CharSequence)entry.getKey()).toString();
            String headerValue = ((CharSequence)entry.getValue()).toString();
            this.request.addTrailer(headerName, headerValue);
        }
        if (trailersFrame.isEndStream()) {
            this.request.finishEntityAndSetTrailers();
        }
    }

    private void onDataFrameRead(Http2DataFrame dataFrame) throws IOException {
        ByteBuf content = dataFrame.content();
        this.request.pushContent(content);
        if (dataFrame.isEndStream()) {
            this.request.finishEntityAndSetTrailers();
        }
    }

    private static boolean hasValidHttp2HeaderNames(Http2Headers headers, boolean allowPseudoHeaders) {
        for (Map.Entry entry : headers) {
            CharSequence name = (CharSequence)entry.getKey();
            if (name == null || name.isEmpty()) {
                return false;
            }
            if (name.charAt(0) == ':') {
                if (!allowPseudoHeaders) {
                    return false;
                }
                if (NettyToMuleHttp2RequestHandlerAdapter.isKnownPseudoHeader(name)) continue;
                return false;
            }
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c < '\u0080' && VALID_TOKEN_CHARS[c]) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isKnownPseudoHeader(CharSequence name) {
        int len = name.length();
        if (len < 5) {
            return false;
        }
        switch (name.charAt(2)) {
            case 'a': {
                return ":path".contentEquals(name);
            }
            case 'c': {
                return ":scheme".contentEquals(name);
            }
            case 'e': {
                return ":method".contentEquals(name);
            }
            case 't': {
                return ":status".contentEquals(name);
            }
            case 'u': {
                return ":authority".contentEquals(name);
            }
            case 'r': {
                return ":protocol".contentEquals(name);
            }
        }
        return false;
    }
}

