/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.mule.runtime.http.api.domain.request.ClientConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyClientConnection
implements ClientConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyClientConnection.class);
    private final InetSocketAddress remoteHostAddress;
    private final SSLSession sslSession;

    public NettyClientConnection(InetSocketAddress remoteHostAddress, SslHandler sslHandler) {
        this.remoteHostAddress = remoteHostAddress;
        this.sslSession = NettyClientConnection.getSslSession(sslHandler);
    }

    private static SSLSession getSslSession(SslHandler sslHandler) {
        if (sslHandler == null) {
            return null;
        }
        SSLEngine engine = sslHandler.engine();
        if (engine == null) {
            return null;
        }
        return engine.getSession();
    }

    public InetSocketAddress getRemoteHostAddress() {
        return this.remoteHostAddress;
    }

    public Certificate getClientCertificate() {
        block3: {
            try {
                Certificate[] peerCertificates;
                if (this.sslSession != null && (peerCertificates = this.sslSession.getPeerCertificates()).length > 0) {
                    return peerCertificates[0];
                }
            }
            catch (SSLPeerUnverifiedException e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Failure getting peer certificates", (Throwable)e);
            }
        }
        return null;
    }
}

