/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.HttpProtocol;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.netty.impl.server.HttpWriter;
import org.mule.service.http.netty.impl.util.MuleToNettyUtils;

public final class Http1Writer
implements HttpWriter {
    private static final int MAX_NUM_HEADERS_DEFAULT = 100;
    private static final String MAX_SERVER_RESPONSE_HEADERS_KEY = "mule.http.MAX_SERVER_RESPONSE_HEADERS";
    private static int maxServerResponseHeaders = Integer.getInteger("mule.http.MAX_SERVER_RESPONSE_HEADERS", 100);
    private final ChannelHandlerContext ctx;

    public Http1Writer(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void writeResponseHeader(HttpRequest request, org.mule.runtime.http.api.domain.message.response.HttpResponse response, ChannelPromise promise) {
        HttpProtocol httpProtocol = request.getProtocol();
        HttpResponse nettyResponse = MuleToNettyUtils.adaptResponseWithoutBody(response, httpProtocol);
        if (nettyResponse.headers().size() > maxServerResponseHeaders) {
            throw new IllegalArgumentException("Exceeded max server response headers limit: " + maxServerResponseHeaders);
        }
        this.ctx.write((Object)nettyResponse);
    }

    @Override
    public void writeContent(ByteBuf content, boolean isLast, ChannelPromise promise) {
        if (isLast) {
            if (content.readableBytes() > 0) {
                this.ctx.writeAndFlush((Object)new DefaultLastHttpContent(content), promise);
            } else {
                this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, promise);
            }
        } else {
            this.ctx.writeAndFlush((Object)new DefaultHttpContent(content), promise);
        }
    }

    @Override
    public void writeTrailers(MultiMap<String, String> trailers, ChannelPromise promise) {
        throw new UnsupportedOperationException("Trailers are not supported for HTTP/1");
    }

    public static void refreshMaxServerResponseHeaders() {
        maxServerResponseHeaders = Integer.getInteger(MAX_SERVER_RESPONSE_HEADERS_KEY, 100);
    }
}

