/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import org.mule.service.http.netty.impl.server.FinishStreamingListener;
import org.mule.service.http.netty.impl.server.SendNextChunkListener;
import org.mule.service.http.netty.impl.streaming.StatusCallback;
import org.mule.service.http.netty.impl.streaming.StreamingEntitySender;

public final class ChannelPromises {
    private ChannelPromises() {
    }

    public static ChannelPromise finishStreamingPromise(ChannelHandlerContext ctx, InputStream stream, StatusCallback statusCallback) {
        return ChannelPromises.createPromise(ctx, new FinishStreamingListener(stream, statusCallback));
    }

    public static ChannelPromise createPromise(ChannelHandlerContext ctx, ChannelFutureListener futureListener) {
        ChannelPromise channelPromise = ctx.newPromise();
        channelPromise.addListener((GenericFutureListener)futureListener);
        return channelPromise;
    }

    public static ChannelPromise sendNextChunkPromise(ChannelHandlerContext ctx, StreamingEntitySender entitySender, StatusCallback statusCallback) {
        ChannelPromise promise = ctx.newPromise();
        promise.addListener((GenericFutureListener)new SendNextChunkListener(entitySender, statusCallback));
        return promise;
    }

    public static ChannelPromise promiseToCallback(ChannelHandlerContext ctx, StatusCallback statusCallback, boolean isLast) {
        ChannelFutureListener futureListener = channelFuture -> {
            if (channelFuture.isSuccess()) {
                if (isLast) {
                    statusCallback.onSuccess();
                }
            } else {
                statusCallback.onFailure(channelFuture.cause());
            }
        };
        return ChannelPromises.createPromise(ctx, futureListener);
    }
}

