/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.message.content;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.Feedable;
import org.mule.service.http.netty.impl.streaming.CancelableOutputStream;

public class StreamAndFutureFeedable
implements Feedable {
    private final CancelableOutputStream dataSink;
    private final CompletableFuture<MultiMap<String, String>> futureTrailers;

    public StreamAndFutureFeedable(CancelableOutputStream dataSink, CompletableFuture<MultiMap<String, String>> futureTrailers) {
        this.dataSink = dataSink;
        this.futureTrailers = futureTrailers;
    }

    public void feed(ByteBuffer data) throws IOException {
        byte[] bytes = new byte[data.remaining()];
        data.get(bytes);
        this.dataSink.write(bytes, 0, bytes.length);
    }

    public void error(Exception exception) {
        this.dataSink.cancel(exception);
    }

    public void complete() throws IOException {
        this.completeWithTrailers((MultiMap<String, String>)MultiMap.emptyMultiMap());
    }

    public void completeWithTrailers(MultiMap<String, String> trailers) throws IOException {
        this.futureTrailers.complete(trailers);
        this.dataSink.close();
    }
}

