/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.message.content;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.entity.EntitySubscription;
import org.mule.runtime.http.api.domain.entity.FeedableHttpEntity;
import org.mule.service.http.netty.impl.streaming.BlockingBidirectionalStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Sinks;

public class NettyFeedableHttpEntity
implements FeedableHttpEntity {
    public static final long UNKNOWN_CONTENT_LENGTH = -1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyFeedableHttpEntity.class);
    private final long contentLength;
    private final CompletableFuture<MultiMap<String, String>> futureTrailers;
    private final Sinks.Many<ByteBuffer> dataSink;
    private final Object consumptionLock = new Object();
    private ConsumptionMode consumptionMode;
    private InputStream asInputStream;
    private final Object completionLock = new Object();
    private boolean isCompleted;
    private boolean closedFromReader = false;
    private Exception savedError;

    public NettyFeedableHttpEntity() {
        this(-1L);
    }

    public NettyFeedableHttpEntity(long contentLength) {
        this.contentLength = contentLength;
        this.consumptionMode = ConsumptionMode.NOT_YET_CONSUMED;
        this.futureTrailers = new CompletableFuture();
        this.dataSink = Sinks.many().unicast().onBackpressureBuffer();
    }

    public boolean isStreaming() {
        return this.consumptionMode.allowsStreaming;
    }

    public boolean isReactive() {
        return this.consumptionMode.allowsReactive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContent() {
        Object object = this.consumptionLock;
        synchronized (object) {
            switch (this.consumptionMode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case NOT_YET_CONSUMED: 
                case AS_INPUT_STREAM: {
                    break;
                }
                case AS_REACTIVE: {
                    throw new IllegalStateException("This entity is being consumed reactively");
                }
            }
            return this.getOrCreateInputStream();
        }
    }

    private InputStream getOrCreateInputStream() {
        if (this.asInputStream == null) {
            this.consumptionMode = ConsumptionMode.AS_INPUT_STREAM;
            BlockingBidirectionalStream bidirectionalStream = new BlockingBidirectionalStream();
            this.dataSink.asFlux().doOnNext(data -> {
                byte[] bytes = new byte[data.remaining()];
                data.get(bytes);
                LOGGER.debug("Feeding piped entity with {} bytes", (Object)bytes.length);
                try {
                    bidirectionalStream.write(bytes, 0, bytes.length);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).doOnError(error -> {
                LOGGER.debug("Canceling piped entity", error);
                this.futureTrailers.completeExceptionally((Throwable)error);
                bidirectionalStream.cancel((Throwable)error);
            }).doOnComplete(() -> {
                LOGGER.debug("Completing piped entity successfully");
                bidirectionalStream.close();
            }).subscribe();
            this.asInputStream = bidirectionalStream.getInputStream();
        }
        return this.asInputStream;
    }

    public byte[] getBytes() throws IOException {
        return IOUtils.toByteArray((InputStream)this.getContent());
    }

    public Optional<Long> getLength() {
        return this.contentLength == -1L ? Optional.empty() : Optional.of(this.contentLength);
    }

    public OptionalLong getBytesLength() {
        return this.contentLength == -1L ? OptionalLong.empty() : OptionalLong.of(this.contentLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void feed(ByteBuffer data) throws IOException {
        Object object = this.completionLock;
        synchronized (object) {
            this.checkIsOpen();
            LOGGER.debug("Feeding entity with {} bytes", (Object)data.remaining());
            Sinks.EmitResult res = this.dataSink.tryEmitNext((Object)data);
            LOGGER.debug("Feed result: {}", (Object)res);
        }
    }

    private void checkIsOpen() throws IOException {
        if (this.closedFromReader) {
            throw new IllegalStateException("HTTP Entity was closed from reader side");
        }
        if (this.isCompleted) {
            throw new IOException("This entity is already completed");
        }
        Exception exception = this.savedError;
        if (exception instanceof IOException) {
            IOException ioException = (IOException)exception;
            throw ioException;
        }
        exception = this.savedError;
        if (exception instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)exception;
            throw runtimeException;
        }
        if (this.savedError != null) {
            throw new IOException(this.savedError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Exception error) {
        Object object = this.completionLock;
        synchronized (object) {
            this.checkNotCompleted();
            this.savedError = error;
            LOGGER.debug("Marking entity with error", (Throwable)error);
            Sinks.EmitResult res = this.dataSink.tryEmitError((Throwable)error);
            LOGGER.debug("Emit error result: {}", (Object)res);
        }
    }

    private void checkNotCompleted() {
        if (this.isCompleted) {
            throw new IllegalStateException("This entity is already completed");
        }
        if (this.savedError != null) {
            throw new IllegalStateException("This entity has already been marked with an error", this.savedError);
        }
    }

    public void complete() {
        this.completeWithTrailers((MultiMap<String, String>)MultiMap.emptyMultiMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeWithTrailers(MultiMap<String, String> trailers) {
        Object object = this.completionLock;
        synchronized (object) {
            this.checkNotCompleted();
            this.isCompleted = true;
            LOGGER.atDebug().log(() -> "Completing HTTP entity with " + trailers.size() + " trailers");
            this.futureTrailers.complete(trailers);
            Sinks.EmitResult res = this.dataSink.tryEmitComplete();
            LOGGER.debug("Emit complete result: {}", (Object)res);
        }
    }

    public void onComplete(BiConsumer<? super MultiMap<String, String>, ? super Throwable> completionCallback) {
        LOGGER.debug("Registering a callback for the entity completion");
        this.futureTrailers.whenComplete(completionCallback);
    }

    public EntitySubscription onData(Consumer<ByteBuffer> consumer) {
        Object object = this.consumptionLock;
        synchronized (object) {
            switch (this.consumptionMode) {
                case NOT_YET_CONSUMED: {
                    return this.registerDataConsumer(consumer);
                }
                case AS_REACTIVE: {
                    throw new IllegalStateException("A consumer has already been registered for this entity");
                }
                case AS_INPUT_STREAM: {
                    throw new IllegalStateException("This entity is being consumed as an input stream");
                }
            }
            throw new IllegalStateException("Unknown consumption mode " + String.valueOf((Object)this.consumptionMode));
        }
    }

    private EntitySubscription registerDataConsumer(Consumer<ByteBuffer> consumer) {
        this.consumptionMode = ConsumptionMode.AS_REACTIVE;
        Disposable disposable = this.dataSink.asFlux().doOnNext(consumer).subscribe();
        return () -> {
            Object object = this.completionLock;
            synchronized (object) {
                disposable.dispose();
                this.closedFromReader = true;
            }
        };
    }

    private static enum ConsumptionMode {
        AS_INPUT_STREAM(true, false),
        AS_REACTIVE(false, true),
        NOT_YET_CONSUMED(true, true);

        public final boolean allowsStreaming;
        public final boolean allowsReactive;

        private ConsumptionMode(boolean allowsStreaming, boolean allowsReactive) {
            this.allowsStreaming = allowsStreaming;
            this.allowsReactive = allowsReactive;
        }
    }
}

