/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth;

import java.util.Base64;
import org.mule.service.http.netty.impl.client.auth.NettyAuthHeaderFactory;

public class BasicAuthHeaderFactory
implements NettyAuthHeaderFactory {
    private final String username;
    private final String password;
    private final boolean isPreemptive;
    private Status status;

    public BasicAuthHeaderFactory(boolean preemptive, String username, String password) {
        this.isPreemptive = preemptive;
        this.username = username;
        this.password = password;
        this.status = Status.NOT_STARTED;
    }

    private String getBasicAuthHeader() {
        String authString = this.username + ":" + this.password;
        return "Basic " + Base64.getEncoder().encodeToString(authString.getBytes());
    }

    @Override
    public boolean hasFinished() {
        return Status.FINISHED == this.status;
    }

    @Override
    public String getNextHeader(String wwwAuthenticateHeader) {
        switch (this.status) {
            case NOT_STARTED: {
                if (this.isPreemptive) {
                    this.status = Status.FINISHED;
                    return this.getBasicAuthHeader();
                }
                this.status = Status.NO_HEADERS_SENT_BECAUSE_NOT_PREEMPTIVE;
                return null;
            }
            case NO_HEADERS_SENT_BECAUSE_NOT_PREEMPTIVE: {
                if (this.isPreemptive) {
                    throw new IllegalStateException("BasicAuthHeaderFactory reached an invalid state");
                }
                this.status = Status.FINISHED;
                return this.getBasicAuthHeader();
            }
            case FINISHED: {
                return null;
            }
        }
        return null;
    }

    static enum Status {
        NOT_STARTED,
        NO_HEADERS_SENT_BECAUSE_NOT_PREEMPTIVE,
        FINISHED;

    }
}

